/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.commons.utils;

import com.github.ltsopensource.core.exception.LtsRuntimeException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;

public class ClassPathScanHandler {
    private boolean excludeInner = true;
    private boolean checkInOrEx = true;
    private List<String> classFilters = null;

    public ClassPathScanHandler() {
    }

    public ClassPathScanHandler(Boolean excludeInner, Boolean checkInOrEx, List<String> classFilters) {
        this.excludeInner = excludeInner;
        this.checkInOrEx = checkInOrEx;
        this.classFilters = classFilters;
    }

    public Set<Class<?>> getPackageAllClasses(String basePackage, boolean recursive) {
        LinkedHashSet classes = new LinkedHashSet();
        String packageName = basePackage;
        if (packageName.endsWith(".")) {
            packageName = packageName.substring(0, packageName.lastIndexOf(46));
        }
        String package2Path = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(package2Path);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    this.doScanPackageClassesByFile(classes, packageName, filePath, recursive);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                this.doScanPackageClassesByJar(packageName, url, recursive, classes);
            }
        }
        catch (IOException e) {
            throw new LtsRuntimeException(e);
        }
        return classes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doScanPackageClassesByJar(String basePackage, URL url, boolean recursive, Set<Class<?>> classes) {
        String package2Path = basePackage.replace('.', '/');
        try {
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String classSimpleName;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(package2Path) || entry.isDirectory() || !recursive && name.lastIndexOf(47) != package2Path.length() || this.excludeInner && name.indexOf(36) != -1 || !this.filterClassName(classSimpleName = name.substring(name.lastIndexOf(47) + 1))) continue;
                String className = name.replace('/', '.');
                className = className.substring(0, className.length() - 6);
                try {
                    classes.add(Thread.currentThread().getContextClassLoader().loadClass(className));
                }
                catch (ClassNotFoundException e) {
                    throw new LtsRuntimeException(e);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new LtsRuntimeException(e);
        }
    }

    private void doScanPackageClassesByFile(Set<Class<?>> classes, String packageName, String packagePath, boolean recursive) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        final boolean fileRecursive = recursive;
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return fileRecursive;
                }
                String filename = file.getName();
                return (!ClassPathScanHandler.this.excludeInner || filename.indexOf(36) == -1) && ClassPathScanHandler.this.filterClassName(filename);
            }
        })) {
            if (file.isDirectory()) {
                this.doScanPackageClassesByFile(classes, packageName + "." + file.getName(), file.getAbsolutePath(), recursive);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className));
            }
            catch (ClassNotFoundException e) {
                throw new LtsRuntimeException(e);
            }
        }
    }

    private boolean filterClassName(String className) {
        if (!className.endsWith(".class")) {
            return false;
        }
        if (null == this.classFilters || this.classFilters.isEmpty()) {
            return true;
        }
        String tmpName = className.substring(0, className.length() - 6);
        boolean flag = false;
        for (String str : this.classFilters) {
            String tmpReg = "^" + str.replace("*", ".*") + "$";
            Pattern p = Pattern.compile(tmpReg);
            if (!p.matcher(tmpName).find()) continue;
            flag = true;
            break;
        }
        return this.checkInOrEx && flag || !this.checkInOrEx && !flag;
    }

    public boolean isExcludeInner() {
        return this.excludeInner;
    }

    public boolean isCheckInOrEx() {
        return this.checkInOrEx;
    }

    public List<String> getClassFilters() {
        return this.classFilters;
    }

    public void setExcludeInner(boolean pExcludeInner) {
        this.excludeInner = pExcludeInner;
    }

    public void setCheckInOrEx(boolean pCheckInOrEx) {
        this.checkInOrEx = pCheckInOrEx;
    }

    public void setClassFilters(List<String> pClassFilters) {
        this.classFilters = pClassFilters;
    }
}

