/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.commons.utils;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class PrimitiveTypeUtils {
    private static final Set<Class<?>> primitiveClasses = new HashSet();

    public static boolean isPrimitiveClass(Class<?> clazz) {
        return primitiveClasses.contains(clazz);
    }

    public static boolean isPrimitiveType(Type type) {
        return primitiveClasses.contains(type);
    }

    public static <T> T convert(Object object, Type type) {
        String valString = object.toString();
        if (type == Byte.class || type == Byte.TYPE) {
            return (T)Byte.valueOf(valString);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.valueOf(valString);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.valueOf(valString);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.valueOf(valString);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(valString);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(valString);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(valString);
        }
        if (type == BigInteger.class) {
            return (T)new BigInteger(valString);
        }
        if (type == BigDecimal.class) {
            return (T)new BigDecimal(valString);
        }
        if (type == String.class) {
            return (T)valString;
        }
        return (T)object;
    }

    public static Class<?> getUnBoxType(Class<?> boxType) {
        if (boxType == null) {
            return null;
        }
        if (boxType == Byte.class) {
            return Byte.TYPE;
        }
        if (boxType == Short.class) {
            return Short.TYPE;
        }
        if (boxType == Integer.class) {
            return Integer.TYPE;
        }
        if (boxType == Long.class) {
            return Long.TYPE;
        }
        if (boxType == Boolean.class) {
            return Boolean.TYPE;
        }
        if (boxType == Float.class) {
            return Float.TYPE;
        }
        return boxType;
    }

    static {
        primitiveClasses.add(Boolean.TYPE);
        primitiveClasses.add(Byte.TYPE);
        primitiveClasses.add(Short.TYPE);
        primitiveClasses.add(Integer.TYPE);
        primitiveClasses.add(Long.TYPE);
        primitiveClasses.add(Float.TYPE);
        primitiveClasses.add(Double.TYPE);
        primitiveClasses.add(Boolean.class);
        primitiveClasses.add(Byte.class);
        primitiveClasses.add(Short.class);
        primitiveClasses.add(Integer.class);
        primitiveClasses.add(Long.class);
        primitiveClasses.add(Float.class);
        primitiveClasses.add(Double.class);
        primitiveClasses.add(BigInteger.class);
        primitiveClasses.add(BigDecimal.class);
        primitiveClasses.add(String.class);
    }
}

