/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.commons.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ReflectionUtils {
    public static Field[] findFields(Class<?> clazz) throws IllegalAccessException {
        final ArrayList fieldList = new ArrayList();
        ReflectionUtils.doWithDeclaredFields(clazz, new FieldCallback(){

            @Override
            public void doWith(Field field) {
                fieldList.add(field);
            }
        });
        return fieldList.toArray(new Field[fieldList.size()]);
    }

    public static Field findField(Class<?> clazz, String name) {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() != null) {
                return ReflectionUtils.findField(clazz.getSuperclass(), name);
            }
            return null;
        }
    }

    private static void doWithDeclaredFields(Class<?> clazz, FieldCallback fieldCallback) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            fieldCallback.doWith(field);
        }
        if (clazz.getSuperclass() != null) {
            ReflectionUtils.doWithDeclaredFields(clazz.getSuperclass(), fieldCallback);
        }
    }

    public static Method[] findMethods(Class<?> clazz) throws IllegalAccessException {
        final ArrayList methodList = new ArrayList();
        ReflectionUtils.doWithDeclaredMethods(clazz, new MethodCallback(){

            @Override
            public void doWith(Method method) {
                methodList.add(method);
            }
        });
        return methodList.toArray(new Method[methodList.size()]);
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> parameterTypes) {
        try {
            if (parameterTypes != null) {
                return clazz.getDeclaredMethod(name, parameterTypes);
            }
            return clazz.getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() != null) {
                return ReflectionUtils.findMethod(clazz.getSuperclass(), name, parameterTypes);
            }
            return null;
        }
    }

    public static Method findMethod(Class<?> clazz, String name) {
        return ReflectionUtils.findMethod(clazz, name, null);
    }

    private static void doWithDeclaredMethods(Class<?> clazz, MethodCallback methodCallback) throws IllegalAccessException {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            methodCallback.doWith(method);
        }
        if (clazz.getSuperclass() != null) {
            ReflectionUtils.doWithDeclaredMethods(clazz.getSuperclass(), methodCallback);
        }
    }

    private static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }

    private static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

