/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.failstore;

import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.commons.file.FileUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.failstore.FailStore;
import com.github.ltsopensource.core.failstore.FailStoreFactory;
import java.io.File;
import java.io.IOException;

public abstract class AbstractFailStoreFactory
implements FailStoreFactory {
    @Override
    public final FailStore getFailStore(Config config, String storePath) {
        if (StringUtils.isEmpty(storePath)) {
            throw new IllegalStateException("storePath should not be empty");
        }
        File dbPath = new File(storePath.concat(this.getName()).concat("/").concat(config.getIdentity()));
        try {
            FileUtils.createDirIfNotExist(dbPath);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this.newInstance(dbPath, true);
    }

    protected abstract String getName();

    protected abstract FailStore newInstance(File var1, boolean var2);
}

