/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.failstore.leveldb;

import com.github.ltsopensource.core.commons.file.FileUtils;
import com.github.ltsopensource.core.domain.Pair;
import com.github.ltsopensource.core.failstore.AbstractFailStore;
import com.github.ltsopensource.core.failstore.FailStoreException;
import com.github.ltsopensource.core.json.JSON;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.Snapshot;
import org.iq80.leveldb.WriteBatch;

public class LeveldbFailStore
extends AbstractFailStore {
    private DB db;
    private Options options;
    public static final String name = "leveldb";

    public LeveldbFailStore(File dbPath, boolean needLock) {
        super(dbPath, needLock);
    }

    @Override
    protected void init() throws FailStoreException {
        try {
            this.options = new Options();
            this.options.createIfMissing(true);
            this.options.cacheSize(0x6400000L);
            this.options.maxOpenFiles(400);
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
    }

    @Override
    protected String getName() {
        return name;
    }

    @Override
    public void open() throws FailStoreException {
        try {
            JniDBFactory.factory.repair(this.dbPath, this.options);
            this.db = JniDBFactory.factory.open(this.dbPath, this.options);
        }
        catch (IOException e) {
            throw new FailStoreException(e);
        }
    }

    @Override
    public void put(String key, Object value) throws FailStoreException {
        try {
            String valueString = JSON.toJSONString(value);
            assert (valueString != null);
            this.db.put(key.getBytes("UTF-8"), valueString.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
    }

    @Override
    public void delete(String key) throws FailStoreException {
        try {
            if (key == null) {
                return;
            }
            this.db.delete(key.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
    }

    @Override
    public void delete(List<String> keys) throws FailStoreException {
        if (keys == null || keys.size() == 0) {
            return;
        }
        WriteBatch batch = this.db.createWriteBatch();
        try {
            for (String key : keys) {
                batch.delete(key.getBytes("UTF-8"));
            }
            this.db.write(batch);
        }
        catch (UnsupportedEncodingException e) {
            throw new FailStoreException(e);
        }
        finally {
            try {
                batch.close();
            }
            catch (IOException ignored) {}
        }
    }

    @Override
    public <T> List<Pair<String, T>> fetchTop(int size, Type type) throws FailStoreException {
        Snapshot snapshot = this.db.getSnapshot();
        DBIterator iterator = null;
        try {
            ArrayList<Pair<String, T>> list = new ArrayList<Pair<String, T>>(size);
            ReadOptions options = new ReadOptions();
            options.snapshot(snapshot);
            iterator = this.db.iterator(options);
            iterator.seekToFirst();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.peekNext();
                String key = new String((byte[])entry.getKey(), "UTF-8");
                Object value = JSON.parse(new String((byte[])entry.getValue(), "UTF-8"), type);
                Pair pair = new Pair(key, value);
                list.add(pair);
                if (list.size() >= size) break;
                iterator.next();
            }
            ArrayList<Pair<String, T>> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
        finally {
            if (iterator != null) {
                try {
                    iterator.close();
                }
                catch (IOException ignored) {}
            }
            try {
                snapshot.close();
            }
            catch (IOException ignored) {}
        }
    }

    @Override
    public void close() throws FailStoreException {
        try {
            if (this.db != null) {
                this.db.close();
            }
        }
        catch (IOException e) {
            throw new FailStoreException(e);
        }
    }

    @Override
    public void destroy() throws FailStoreException {
        try {
            this.close();
            JniDBFactory.factory.destroy(this.dbPath, this.options);
        }
        catch (IOException e) {
            throw new FailStoreException(e);
        }
        finally {
            if (this.fileLock != null) {
                this.fileLock.release();
            }
            FileUtils.delete(this.dbPath);
        }
    }
}

