/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.logger.support;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.support.FormattingTuple;
import com.github.ltsopensource.core.logger.support.MessageFormatter;

public abstract class AbstractLogger
implements Logger {
    @Override
    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            this.trace(ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            this.debug(ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            this.info(ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            this.warn(ft.getMessage(), ft.getThrowable());
        }
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            this.error(ft.getMessage(), ft.getThrowable());
        }
    }
}

