/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.registry.redis;

import redis.clients.jedis.Jedis;

public class RedisLock {
    private String lockKey;
    private String lockValue;
    private int expiredSeconds;

    public RedisLock(String lockKey, String lockValue, int expiredSeconds) {
        this.lockValue = lockValue;
        this.lockKey = lockKey;
        this.expiredSeconds = expiredSeconds;
    }

    public boolean acquire(Jedis jedis) {
        String value = jedis.get(this.lockKey);
        if (value == null) {
            boolean success;
            boolean bl = success = jedis.setnx(this.lockKey, this.lockValue) == 1L;
            if (success) {
                jedis.expire(this.lockKey, this.expiredSeconds);
                return true;
            }
        } else if (this.lockValue.equals(value)) {
            jedis.expire(this.lockKey, this.expiredSeconds);
            return true;
        }
        return false;
    }
}

