/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.remoting;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.exception.RemotingSendException;
import com.github.ltsopensource.remoting.AsyncCallback;
import com.github.ltsopensource.remoting.Channel;
import com.github.ltsopensource.remoting.RemotingProcessor;
import com.github.ltsopensource.remoting.RemotingServer;
import com.github.ltsopensource.remoting.exception.RemotingException;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import java.util.concurrent.ExecutorService;

public class RemotingServerDelegate {
    private RemotingServer remotingServer;
    private AppContext appContext;

    public RemotingServerDelegate(RemotingServer remotingServer, AppContext appContext) {
        this.remotingServer = remotingServer;
        this.appContext = appContext;
    }

    public void start() {
        try {
            this.remotingServer.start();
        }
        catch (RemotingException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerProcessor(int requestCode, RemotingProcessor processor, ExecutorService executor) {
        this.remotingServer.registerProcessor(requestCode, processor, executor);
    }

    public void registerDefaultProcessor(RemotingProcessor processor, ExecutorService executor) {
        this.remotingServer.registerDefaultProcessor(processor, executor);
    }

    public RemotingCommand invokeSync(Channel channel, RemotingCommand request) throws RemotingSendException {
        try {
            return this.remotingServer.invokeSync(channel, request, this.appContext.getConfig().getInvokeTimeoutMillis());
        }
        catch (Throwable t) {
            throw new RemotingSendException(t);
        }
    }

    public void invokeAsync(Channel channel, RemotingCommand request, AsyncCallback asyncCallback) throws RemotingSendException {
        try {
            this.remotingServer.invokeAsync(channel, request, this.appContext.getConfig().getInvokeTimeoutMillis(), asyncCallback);
        }
        catch (Throwable t) {
            throw new RemotingSendException(t);
        }
    }

    public void invokeOneway(Channel channel, RemotingCommand request) throws RemotingSendException {
        try {
            this.remotingServer.invokeOneway(channel, request, this.appContext.getConfig().getInvokeTimeoutMillis());
        }
        catch (Throwable t) {
            throw new RemotingSendException(t);
        }
    }

    public void shutdown() {
        this.remotingServer.shutdown();
    }
}

