/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.support;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

public class AliveKeeping {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliveKeeping.class);
    private static Timer timer;
    private static AtomicBoolean start;

    public static void start() {
        if (start.compareAndSet(false, true)) {
            timer = new Timer("AliveKeepingService");
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("I'm alive");
                    }
                }
            }, 600000L, 600000L);
        }
    }

    public static void stop() {
        if (start.compareAndSet(true, false) && timer != null) {
            timer.cancel();
        }
    }

    static {
        start = new AtomicBoolean(false);
    }
}

