/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jvmmonitor;

import com.github.ltsopensource.core.domain.monitor.JvmMData;
import com.github.ltsopensource.jvmmonitor.JVMMonitor;
import com.github.ltsopensource.jvmmonitor.mbean.JVMGCMBean;
import com.github.ltsopensource.jvmmonitor.mbean.JVMInfoMBean;
import com.github.ltsopensource.jvmmonitor.mbean.JVMMemoryMBean;
import com.github.ltsopensource.jvmmonitor.mbean.JVMThreadMBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JVMCollector {
    public static JvmMData collect() {
        JvmMData JVMMData = new JvmMData();
        Map<String, Object> memoryMap = JVMMonitor.getAttribute("com.github.ltsopensource.jvmmonitor:type=JVMMemory", JVMCollector.getAttributeList(JVMMemoryMBean.class));
        JVMMData.setMemoryMap(memoryMap);
        Map<String, Object> gcMap = JVMMonitor.getAttribute("com.github.ltsopensource.jvmmonitor:type=JVMGC", JVMCollector.getAttributeList(JVMGCMBean.class));
        JVMMData.setGcMap(gcMap);
        Map<String, Object> threadMap = JVMMonitor.getAttribute("com.github.ltsopensource.jvmmonitor:type=JVMThread", JVMCollector.getAttributeList(JVMThreadMBean.class));
        JVMMData.setThreadMap(threadMap);
        return JVMMData;
    }

    private static List<String> getAttributeList(Class<?> clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        ArrayList<String> attributeList = new ArrayList<String>(methods.length);
        for (Method method : methods) {
            attributeList.add(method.getName().substring(3));
        }
        return attributeList;
    }

    public static Map<String, Object> getJVMInfo() {
        return JVMMonitor.getAttribute("com.github.ltsopensource.jvmmonitor:type=JVMInfo", JVMCollector.getAttributeList(JVMInfoMBean.class));
    }
}

