/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jvmmonitor.mbean;

import com.github.ltsopensource.jvmmonitor.mbean.JVMGCMBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;

public class JVMGC
implements JVMGCMBean {
    private static final JVMGC instance = new JVMGC();
    private GarbageCollectorMXBean fullGC;
    private GarbageCollectorMXBean youngGC;
    private long lastYoungGCCollectionCount = -1L;
    private long lastYoungGCCollectionTime = -1L;
    private long lastFullGCCollectionCount = -1L;
    private long lastFullGCCollectionTime = -1L;

    public static JVMGC getInstance() {
        return instance;
    }

    private JVMGC() {
        for (GarbageCollectorMXBean item : ManagementFactory.getGarbageCollectorMXBeans()) {
            if ("ConcurrentMarkSweep".equals(item.getName()) || "MarkSweepCompact".equals(item.getName()) || "PS MarkSweep".equals(item.getName()) || "G1 Old Generation".equals(item.getName()) || "Garbage collection optimized for short pausetimes Old Collector".equals(item.getName()) || "Garbage collection optimized for throughput Old Collector".equals(item.getName()) || "Garbage collection optimized for deterministic pausetimes Old Collector".equals(item.getName())) {
                this.fullGC = item;
                continue;
            }
            if (!"ParNew".equals(item.getName()) && !"Copy".equals(item.getName()) && !"PS Scavenge".equals(item.getName()) && !"G1 Young Generation".equals(item.getName()) && !"Garbage collection optimized for short pausetimes Young Collector".equals(item.getName()) && !"Garbage collection optimized for throughput Young Collector".equals(item.getName()) && !"Garbage collection optimized for deterministic pausetimes Young Collector".equals(item.getName())) continue;
            this.youngGC = item;
        }
    }

    @Override
    public long getYoungGCCollectionCount() {
        if (this.youngGC == null) {
            return 0L;
        }
        return this.youngGC.getCollectionCount();
    }

    @Override
    public long getYoungGCCollectionTime() {
        if (this.youngGC == null) {
            return 0L;
        }
        return this.youngGC.getCollectionTime();
    }

    @Override
    public long getFullGCCollectionCount() {
        if (this.fullGC == null) {
            return 0L;
        }
        return this.fullGC.getCollectionCount();
    }

    @Override
    public long getFullGCCollectionTime() {
        if (this.fullGC == null) {
            return 0L;
        }
        return this.fullGC.getCollectionTime();
    }

    @Override
    public long getSpanYoungGCCollectionCount() {
        long current = this.getYoungGCCollectionCount();
        if (this.lastYoungGCCollectionCount == -1L) {
            this.lastYoungGCCollectionCount = current;
            return 0L;
        }
        long result = current - this.lastYoungGCCollectionCount;
        this.lastYoungGCCollectionCount = current;
        return result;
    }

    @Override
    public long getSpanYoungGCCollectionTime() {
        long current = this.getYoungGCCollectionTime();
        if (this.lastYoungGCCollectionTime == -1L) {
            this.lastYoungGCCollectionTime = current;
            return 0L;
        }
        long result = current - this.lastYoungGCCollectionTime;
        this.lastYoungGCCollectionTime = current;
        return result;
    }

    @Override
    public long getSpanFullGCCollectionCount() {
        long current = this.getFullGCCollectionCount();
        if (this.lastFullGCCollectionCount == -1L) {
            this.lastFullGCCollectionCount = current;
            return 0L;
        }
        long result = current - this.lastFullGCCollectionCount;
        this.lastFullGCCollectionCount = current;
        return result;
    }

    @Override
    public long getSpanFullGCCollectionTime() {
        long current = this.getFullGCCollectionTime();
        if (this.lastFullGCCollectionTime == -1L) {
            this.lastFullGCCollectionTime = current;
            return 0L;
        }
        long result = current - this.lastFullGCCollectionTime;
        this.lastFullGCCollectionTime = current;
        return result;
    }
}

