/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.kv;

import com.github.ltsopensource.core.constant.Constants;
import com.github.ltsopensource.kv.DB;
import com.github.ltsopensource.kv.DBImpl;
import com.github.ltsopensource.kv.StoreConfig;
import com.github.ltsopensource.kv.serializer.JsonStoreSerializer;
import com.github.ltsopensource.kv.serializer.StoreSerializer;
import java.io.File;

public class DBBuilder<K, V> {
    private StoreSerializer serializer;
    private StoreConfig storeConfig = new StoreConfig();

    public DB<K, V> create() {
        if (this.serializer == null) {
            this.serializer = new JsonStoreSerializer();
        }
        if (this.storeConfig.getDbPath() == null) {
            this.storeConfig.setDbPath(new File(Constants.USER_HOME));
        }
        this.storeConfig.setDataPath(new File(this.storeConfig.getDbPath(), "data"));
        this.storeConfig.setLogPath(new File(this.storeConfig.getDbPath(), "logs"));
        this.storeConfig.setIndexPath(new File(this.storeConfig.getDbPath(), "index"));
        return new DBImpl(this.serializer, this.storeConfig);
    }

    public DBBuilder<K, V> setPath(File path) {
        this.storeConfig.setDbPath(path);
        return this;
    }

    public DBBuilder<K, V> setPath(String path) {
        this.storeConfig.setDbPath(new File(path));
        return this;
    }

    public DBBuilder<K, V> setSerializer(StoreSerializer serializer) {
        this.serializer = serializer;
        return this;
    }
}

