/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.kv.txlog;

import com.github.ltsopensource.core.commons.file.FileUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.kv.CapacityNotEnoughException;
import com.github.ltsopensource.kv.DB;
import com.github.ltsopensource.kv.DBException;
import com.github.ltsopensource.kv.FutureTimerTask;
import com.github.ltsopensource.kv.StoreConfig;
import com.github.ltsopensource.kv.txlog.StoreTxLogFileHeader;
import com.github.ltsopensource.kv.txlog.StoreTxLogPosition;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Timer;
import java.util.TimerTask;

public class StoreTxLog
implements Closeable {
    private static final Logger LOGGER = DB.LOGGER;
    private StoreTxLog next;
    private FileChannel fileChannel;
    private StoreConfig storeConfig;
    private final ByteBuffer entryBuffer;
    private StoreTxLogFileHeader fileHeader;
    private static final int ENTRY_HEAD_LENGTH = 5;
    private static final byte magic = -94;
    public static final String LOG_FILE_SUFFIX = ".log";
    private long lastCheckPointLength = 0L;
    private Timer syncTimer;
    private FutureTimerTask syncTimerTask;
    private FutureTimerTask.Callable syncCallable;
    private long fileLength;

    public StoreTxLog(StoreConfig storeConfig, File file, boolean readonly, boolean isNewFile, long firstRecordId) throws IOException {
        this.storeConfig = storeConfig;
        this.entryBuffer = ByteBuffer.allocate(storeConfig.getMaxxLogEntryLength() + 1 + 4);
        this.fileHeader = new StoreTxLogFileHeader();
        if (!readonly) {
            this.syncTimer = new Timer("ltsdb-dblog-sync-timer", true);
            this.syncCallable = new FutureTimerTask.Callable(){

                @Override
                public void call() throws Exception {
                    StoreTxLog.this.checkPoint();
                }
            };
        }
        if (isNewFile && file.exists()) {
            throw new IOException(file + " exists already");
        }
        FileUtils.createFileIfNotExist(file);
        this.fileChannel = FileUtils.newFileChannel(file, "rw");
        if (isNewFile) {
            this.fileLength = this.fileHeader.getLength();
            this.fileHeader.setFirstRecordId(firstRecordId);
            this.fileHeader.write(this.fileChannel);
        } else {
            this.fileHeader.read(this.fileChannel);
            this.lastCheckPointLength = this.fileLength = this.fileChannel.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreTxLogPosition append(byte[] entry) throws IOException {
        int length = entry.length;
        if (length > this.storeConfig.getMaxxLogEntryLength()) {
            throw new DBException("Value size can not great than " + this.storeConfig.getMaxxLogEntryLength());
        }
        if (this.fileLength + (long)length + 5L > (long)this.storeConfig.getTxLogFileSize()) {
            throw new CapacityNotEnoughException();
        }
        StoreTxLogPosition result = new StoreTxLogPosition();
        result.setRecordId(this.getNextRecordId());
        boolean ok = false;
        try {
            this.entryBuffer.clear();
            this.entryBuffer.put((byte)-94);
            this.entryBuffer.putInt(length);
            this.entryBuffer.put(entry);
            this.entryBuffer.flip();
            this.fileChannel.position(this.fileLength);
            this.fileChannel.write(this.entryBuffer);
            int entryLength = 5 + length;
            this.fileLength += (long)entryLength;
            ok = true;
        }
        finally {
            if (ok && (this.syncTimerTask == null || this.syncTimerTask.isDone())) {
                this.syncTimerTask = new FutureTimerTask("ltsdb-dblog-sync-timertask", this.syncCallable);
                this.syncTimer.schedule((TimerTask)this.syncTimerTask, this.storeConfig.getDbLogFlushInterval());
            }
        }
        return result;
    }

    public byte[] readEntry(long position) throws IOException {
        this.fileChannel.position(position);
        this.entryBuffer.clear();
        this.fileChannel.read(this.entryBuffer);
        this.entryBuffer.position(0);
        byte readMagic = this.entryBuffer.get();
        if (readMagic != -94) {
            throw new IOException("Invalid entry type magic number 0x" + Integer.toHexString(readMagic & 0xFFFF));
        }
        int length = this.entryBuffer.getInt();
        byte[] entry = new byte[length];
        this.entryBuffer.get(entry);
        return entry;
    }

    public long nextEntryPosition(long position, long entryLength) {
        return position + entryLength + 1L + 4L;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public long getNextRecordId() {
        return this.fileHeader.getFirstRecordId() + this.fileLength;
    }

    public long getFirstRecordId() {
        return this.fileHeader.getFirstRecordId();
    }

    private void checkPoint() throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("checkpoint start");
        }
        if (this.fileLength != this.lastCheckPointLength) {
            this.fileChannel.force(true);
            this.lastCheckPointLength = this.fileLength;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("checkpoint end: fileLength=" + this.fileLength);
        }
    }

    public void setNext(StoreTxLog next) {
        this.next = next;
    }

    public StoreTxLog next() {
        return this.next;
    }

    public int getHeaderLength() {
        return this.fileHeader.getLength();
    }

    @Override
    public void close() throws IOException {
        this.checkPoint();
    }
}

