/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.nio.codec;

import com.github.ltsopensource.nio.channel.NioChannel;
import com.github.ltsopensource.nio.codec.Decoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public abstract class FrameDecoder<T>
implements Decoder {
    private static final int MESSAGE_LENGTH_HEAD = 4;

    @Override
    public List<Object> decode(NioChannel channel, ByteBuffer input) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        while (input.remaining() > 4) {
            byte[] lengthBytes = new byte[4];
            input.mark();
            input.get(lengthBytes);
            int length = ByteBuffer.wrap(lengthBytes).getInt();
            if (length == 0 || length > input.remaining()) {
                input.reset();
                return list;
            }
            byte[] bytes = new byte[length];
            input.get(bytes, 0, length);
            T obj = this.decode(channel, bytes);
            list.add(obj);
        }
        return list;
    }

    protected abstract T decode(NioChannel var1, byte[] var2) throws Exception;
}

