/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.nio.idle;

import com.github.ltsopensource.core.commons.concurrent.ConcurrentHashSet;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.nio.channel.NioChannel;
import com.github.ltsopensource.nio.channel.NioChannelImpl;
import com.github.ltsopensource.nio.config.NioConfig;
import com.github.ltsopensource.nio.handler.Futures;
import com.github.ltsopensource.nio.handler.IoFutureListener;
import com.github.ltsopensource.nio.idle.IdleInfo;
import com.github.ltsopensource.nio.idle.IdleState;
import com.github.ltsopensource.remoting.Future;

public class IdleDetector {
    private final ConcurrentHashSet<NioChannel> channels = new ConcurrentHashSet();
    private DetectorTask task = new DetectorTask();

    public void addChannel(NioChannel channel) {
        this.channels.add(channel);
        channel.getCloseFuture().addListener(new IoFutureListener(){

            @Override
            public void operationComplete(Future future) throws Exception {
                IdleDetector.this.removeChannel(((Futures.CloseFuture)future).channel());
            }
        });
    }

    public void removeChannel(NioChannel channel) {
        this.channels.remove(channel);
    }

    public void start() {
        new Thread(this.task).start();
    }

    public void stop() {
        this.task.stop();
    }

    private class DetectorTask
    implements Runnable {
        private volatile boolean stop = false;
        private volatile Thread thread;

        private DetectorTask() {
        }

        @Override
        public void run() {
            this.thread = Thread.currentThread();
            while (!this.stop) {
                long currentTime = SystemClock.now();
                for (NioChannel channel : IdleDetector.this.channels) {
                    if (!channel.isConnected()) continue;
                    this.idleCheck0((NioChannelImpl)channel, currentTime);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void stop() {
            this.stop = true;
            Thread thread = this.thread;
            if (thread != null) {
                thread.interrupt();
            }
        }

        private void idleCheck0(NioChannelImpl channel, long currentTime) {
            IdleInfo idle = channel.getIdleInfo();
            long lastReadTime = idle.getLastReadTime();
            long lastWriteTime = idle.getLastWriteTime();
            long lastIoTime = Math.max(lastReadTime, lastWriteTime);
            NioConfig config = channel.getConfig();
            if (config.getIdleTimeBoth() > 0L) {
                this.notifyIdle(channel, IdleState.BOTH_IDLE, currentTime, config.getIdleTimeBoth() * 1000L, Math.max(lastIoTime, idle.getLastBothIdleTime()));
            }
            if (config.getIdleTimeRead() > 0) {
                this.notifyIdle(channel, IdleState.READER_IDLE, currentTime, config.getIdleTimeRead() * 1000, Math.max(lastIoTime, idle.getLastReadIdleTime()));
            }
            if (config.getIdleTimeWrite() > 0) {
                this.notifyIdle(channel, IdleState.WRITER_IDLE, currentTime, config.getIdleTimeWrite() * 1000, Math.max(lastIoTime, idle.getLastWriteIdleTime()));
            }
            this.notifyWriteTimeout(channel, currentTime);
        }

        private void notifyWriteTimeout(NioChannelImpl channel, long currentTime) {
        }

        private void notifyIdle(NioChannelImpl channel, IdleState state, long currentTime, long idleTime, long lastIoTime) {
            if (idleTime > 0L && lastIoTime != 0L && currentTime - lastIoTime >= idleTime) {
                channel.fireChannelIdle(state, currentTime);
            }
        }
    }
}

