/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.queue;

import com.github.ltsopensource.core.commons.concurrent.ConcurrentHashSet;
import com.github.ltsopensource.queue.domain.JobPo;
import java.util.Comparator;
import java.util.concurrent.locks.ReentrantLock;

public class JobPriorityBlockingQueue {
    private final ReentrantLock lock;
    private transient Comparator<JobPo> comparator;
    private int capacity;
    private volatile int size;
    private JobPo[] queue;
    private ConcurrentHashSet<String> JOB_ID_SET = new ConcurrentHashSet();

    public JobPriorityBlockingQueue(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.lock = new ReentrantLock();
        this.comparator = new Comparator<JobPo>(){

            @Override
            public int compare(JobPo left, JobPo right) {
                if (left.getJobId().equals(right.getJobId())) {
                    return 0;
                }
                int compare = left.getPriority().compareTo(right.getPriority());
                if (compare != 0) {
                    return compare;
                }
                compare = left.getTriggerTime().compareTo(right.getTriggerTime());
                if (compare != 0) {
                    return compare;
                }
                compare = left.getGmtCreated().compareTo(right.getGmtCreated());
                if (compare != 0) {
                    return compare;
                }
                return -1;
            }
        };
        this.queue = new JobPo[this.capacity];
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(JobPo e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.size >= this.capacity) {
            return false;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        int n = this.size;
        try {
            if (this.JOB_ID_SET.contains(e.getJobId())) {
                this.replace(e);
            } else {
                this.siftUpUsingComparator(n, e, this.queue, this.comparator);
                this.size = n + 1;
                this.JOB_ID_SET.add(e.getJobId());
            }
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobPo poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.size - 1;
            if (n < 0) {
                JobPo jobPo = null;
                return jobPo;
            }
            Object[] array = this.queue;
            JobPo result = array[0];
            JobPo x = array[n];
            array[n] = null;
            this.siftDownUsingComparator(0, x, array, n, this.comparator);
            this.size = n;
            this.JOB_ID_SET.remove(result.getJobId());
            JobPo jobPo = result;
            return jobPo;
        }
        finally {
            lock.unlock();
        }
    }

    private <E> void siftDownUsingComparator(int k, E x, Object[] array, int n, Comparator<? super E> cmp) {
        if (n > 0) {
            int half = n >>> 1;
            while (k < half) {
                int code;
                int child = (k << 1) + 1;
                Object c = array[child];
                int right = child + 1;
                if (right < n && cmp.compare(c, array[right]) > 0) {
                    child = right;
                    c = array[child];
                }
                if ((code = cmp.compare(x, c)) <= 0) break;
                array[k] = c;
                k = child;
            }
            array[k] = x;
        }
    }

    private <E> void siftUpUsingComparator(int k, E x, Object[] array, Comparator<? super E> cmp) {
        int parent;
        Object e;
        int compCode;
        while (k > 0 && (compCode = cmp.compare(x, e = array[parent = k - 1 >>> 1])) < 0) {
            array[k] = e;
            k = parent;
        }
        array[k] = x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean replace(JobPo o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.indexOf(o);
            if (i != -1) {
                this.queue[i] = o;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    private int indexOf(JobPo o) {
        if (o != null) {
            JobPo[] array = this.queue;
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!o.getJobId().equals(array[i].getJobId())) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.size;
            if (n == 0) {
                String string = "[]";
                return string;
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (int i = 0; i < n; ++i) {
                JobPo e = this.queue[i];
                sb.append(e == this ? "(this Collection)" : e);
                if (i == n - 1) continue;
                sb.append(',').append(' ');
            }
            String string = sb.append(']').toString();
            return string;
        }
        finally {
            lock.unlock();
        }
    }
}

