/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.queue.mysql;

import com.github.ltsopensource.admin.request.JobQueueReq;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.queue.ExecutingJobQueue;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.queue.mysql.AbstractMysqlJobQueue;
import com.github.ltsopensource.queue.mysql.support.RshHolder;
import com.github.ltsopensource.store.jdbc.builder.DeleteSql;
import com.github.ltsopensource.store.jdbc.builder.SelectSql;
import java.util.List;

public class MysqlExecutingJobQueue
extends AbstractMysqlJobQueue
implements ExecutingJobQueue {
    public MysqlExecutingJobQueue(Config config) {
        super(config);
        this.createTable(this.readSqlFile("sql/mysql/lts_executing_job_queue.sql", this.getTableName()));
    }

    @Override
    protected String getTableName(JobQueueReq request) {
        return this.getTableName();
    }

    @Override
    public boolean add(JobPo jobPo) {
        return super.add(this.getTableName(), jobPo);
    }

    @Override
    public boolean remove(String jobId) {
        return new DeleteSql(this.getSqlTemplate()).delete().from().table(this.getTableName()).where("job_id = ?", jobId).doDelete() == 1;
    }

    @Override
    public List<JobPo> getJobs(String taskTrackerIdentity) {
        return new SelectSql(this.getSqlTemplate()).select().all().from().table(this.getTableName()).where("task_tracker_identity = ?", taskTrackerIdentity).list(RshHolder.JOB_PO_LIST_RSH);
    }

    @Override
    public List<JobPo> getDeadJobs(long deadline) {
        return new SelectSql(this.getSqlTemplate()).select().all().from().table(this.getTableName()).where("gmt_created < ?", deadline).list(RshHolder.JOB_PO_LIST_RSH);
    }

    @Override
    public JobPo getJob(String taskTrackerNodeGroup, String taskId) {
        return new SelectSql(this.getSqlTemplate()).select().all().from().table(this.getTableName()).where("task_id = ?", taskId).and("task_tracker_node_group = ?", taskTrackerNodeGroup).single(RshHolder.JOB_PO_RSH);
    }

    @Override
    public JobPo getJob(String jobId) {
        return new SelectSql(this.getSqlTemplate()).select().all().from().table(this.getTableName()).where("job_id = ?", jobId).single(RshHolder.JOB_PO_RSH);
    }

    private String getTableName() {
        return "lts_executing_job_queue";
    }
}

