/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting;

import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.domain.Pair;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.remoting.AsyncCallback;
import com.github.ltsopensource.remoting.Channel;
import com.github.ltsopensource.remoting.ChannelEventListener;
import com.github.ltsopensource.remoting.ChannelHandlerListener;
import com.github.ltsopensource.remoting.Future;
import com.github.ltsopensource.remoting.IdleState;
import com.github.ltsopensource.remoting.RemotingEvent;
import com.github.ltsopensource.remoting.RemotingProcessor;
import com.github.ltsopensource.remoting.ResponseFuture;
import com.github.ltsopensource.remoting.codec.Codec;
import com.github.ltsopensource.remoting.codec.DefaultCodec;
import com.github.ltsopensource.remoting.common.RemotingHelper;
import com.github.ltsopensource.remoting.common.SemaphoreReleaseOnlyOnce;
import com.github.ltsopensource.remoting.common.ServiceThread;
import com.github.ltsopensource.remoting.exception.RemotingSendRequestException;
import com.github.ltsopensource.remoting.exception.RemotingTimeoutException;
import com.github.ltsopensource.remoting.exception.RemotingTooMuchRequestException;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import com.github.ltsopensource.remoting.protocol.RemotingCommandHelper;
import com.github.ltsopensource.remoting.protocol.RemotingProtos;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public abstract class AbstractRemoting {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRemoting.class);
    protected final Semaphore semaphoreOneway;
    protected final Semaphore semaphoreAsync;
    protected final ConcurrentHashMap<Integer, ResponseFuture> responseTable = new ConcurrentHashMap(256);
    protected final HashMap<Integer, Pair<RemotingProcessor, ExecutorService>> processorTable = new HashMap(64);
    protected final RemotingEventExecutor remotingEventExecutor = new RemotingEventExecutor();
    protected Pair<RemotingProcessor, ExecutorService> defaultRequestProcessor;
    protected final ChannelEventListener channelEventListener;

    public AbstractRemoting(int permitsOneway, int permitsAsync, ChannelEventListener channelEventListener) {
        this.semaphoreOneway = new Semaphore(permitsOneway, true);
        this.semaphoreAsync = new Semaphore(permitsAsync, true);
        this.channelEventListener = channelEventListener;
    }

    public ChannelEventListener getChannelEventListener() {
        return this.channelEventListener;
    }

    public void putRemotingEvent(RemotingEvent event) {
        this.remotingEventExecutor.putRemotingEvent(event);
    }

    public void processRequestCommand(final Channel channel, final RemotingCommand cmd) {
        Pair<RemotingProcessor, ExecutorService> pair;
        Pair<RemotingProcessor, ExecutorService> matched = this.processorTable.get(cmd.getCode());
        Pair<RemotingProcessor, ExecutorService> pair2 = pair = null == matched ? this.defaultRequestProcessor : matched;
        if (pair != null) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    block5: {
                        try {
                            final RemotingCommand response = ((RemotingProcessor)pair.getKey()).processRequest(channel, cmd);
                            if (!RemotingCommandHelper.isOnewayRPC(cmd) && response != null) {
                                response.setOpaque(cmd.getOpaque());
                                RemotingCommandHelper.markResponseType(cmd);
                                try {
                                    channel.writeAndFlush(response).addListener(new ChannelHandlerListener(){

                                        @Override
                                        public void operationComplete(Future future) throws Exception {
                                            if (!future.isSuccess()) {
                                                LOGGER.error("response to " + RemotingHelper.parseChannelRemoteAddr(channel) + " failed", future.cause());
                                                LOGGER.error(cmd.toString());
                                                LOGGER.error(response.toString());
                                            }
                                        }
                                    });
                                }
                                catch (Exception e) {
                                    LOGGER.error("process request over, but response failed", e);
                                    LOGGER.error(cmd.toString());
                                    LOGGER.error(response.toString());
                                }
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("process request exception", e);
                            LOGGER.error(cmd.toString());
                            if (RemotingCommandHelper.isOnewayRPC(cmd)) break block5;
                            RemotingCommand response = RemotingCommand.createResponseCommand(RemotingProtos.ResponseCode.SYSTEM_ERROR.code(), StringUtils.toString(e));
                            response.setOpaque(cmd.getOpaque());
                            channel.writeAndFlush(response);
                        }
                    }
                }
            };
            try {
                pair.getValue().submit(run);
            }
            catch (RejectedExecutionException e) {
                LOGGER.warn(RemotingHelper.parseChannelRemoteAddr(channel) + ", too many requests and system thread pool busy, RejectedExecutionException " + pair.getKey().toString() + " request code: " + cmd.getCode());
                if (!RemotingCommandHelper.isOnewayRPC(cmd)) {
                    RemotingCommand response = RemotingCommand.createResponseCommand(RemotingProtos.ResponseCode.SYSTEM_BUSY.code(), "too many requests and system thread pool busy, please try another server");
                    response.setOpaque(cmd.getOpaque());
                    channel.writeAndFlush(response);
                }
            }
        } else {
            String error = " request type " + cmd.getCode() + " not supported";
            RemotingCommand response = RemotingCommand.createResponseCommand(RemotingProtos.ResponseCode.REQUEST_CODE_NOT_SUPPORTED.code(), error);
            response.setOpaque(cmd.getOpaque());
            channel.writeAndFlush(response);
            LOGGER.error(RemotingHelper.parseChannelRemoteAddr(channel) + error);
        }
    }

    public void processResponseCommand(Channel channel, RemotingCommand cmd) {
        final ResponseFuture responseFuture = this.responseTable.get(cmd.getOpaque());
        if (responseFuture != null) {
            responseFuture.setResponseCommand(cmd);
            responseFuture.release();
            if (responseFuture.getAsyncCallback() != null) {
                boolean runInThisThread = false;
                ExecutorService executor = this.getCallbackExecutor();
                if (executor != null) {
                    try {
                        executor.submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    responseFuture.executeInvokeCallback();
                                }
                                catch (Exception e) {
                                    LOGGER.warn("execute callback in executor exception, and callback throw", e);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        runInThisThread = true;
                        LOGGER.warn("execute callback in executor exception, maybe executor busy", e);
                    }
                } else {
                    runInThisThread = true;
                }
                if (runInThisThread) {
                    try {
                        responseFuture.executeInvokeCallback();
                    }
                    catch (Exception e) {
                        LOGGER.warn("", e);
                    }
                }
            } else {
                responseFuture.putResponse(cmd);
            }
        } else {
            LOGGER.warn("receive response, but not matched any request, " + RemotingHelper.parseChannelRemoteAddr(channel));
            LOGGER.warn(cmd.toString());
        }
        this.responseTable.remove(cmd.getOpaque());
    }

    public void processMessageReceived(Channel channel, RemotingCommand cmd) throws Exception {
        if (cmd != null) {
            switch (RemotingCommandHelper.getRemotingCommandType(cmd)) {
                case REQUEST_COMMAND: {
                    this.processRequestCommand(channel, cmd);
                    break;
                }
                case RESPONSE_COMMAND: {
                    this.processResponseCommand(channel, cmd);
                    break;
                }
            }
        }
    }

    protected abstract ExecutorService getCallbackExecutor();

    public void scanResponseTable() {
        Iterator<Map.Entry<Integer, ResponseFuture>> it = this.responseTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, ResponseFuture> next = it.next();
            ResponseFuture rep = next.getValue();
            if (rep.getBeginTimestamp() + rep.getTimeoutMillis() + 1000L > SystemClock.now()) continue;
            it.remove();
            rep.release();
            try {
                rep.executeInvokeCallback();
            }
            catch (Exception e) {
                LOGGER.error("scanResponseTable, operationComplete exception", e);
            }
            LOGGER.warn("remove timeout request, " + rep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemotingCommand invokeSyncImpl(final Channel channel, final RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingSendRequestException, RemotingTimeoutException {
        try {
            final ResponseFuture responseFuture = new ResponseFuture(request.getOpaque(), timeoutMillis, null, null);
            this.responseTable.put(request.getOpaque(), responseFuture);
            channel.writeAndFlush(request).addListener(new ChannelHandlerListener(){

                @Override
                public void operationComplete(Future future) throws Exception {
                    if (future.isSuccess()) {
                        responseFuture.setSendRequestOK(true);
                        return;
                    }
                    responseFuture.setSendRequestOK(false);
                    AbstractRemoting.this.responseTable.remove(request.getOpaque());
                    responseFuture.setCause(future.cause());
                    responseFuture.putResponse(null);
                    LOGGER.warn("send a request command to channel <" + channel.remoteAddress() + "> failed.");
                    LOGGER.warn(request.toString());
                }
            });
            RemotingCommand responseCommand = responseFuture.waitResponse(timeoutMillis);
            if (null == responseCommand) {
                if (responseFuture.isSendRequestOK()) {
                    throw new RemotingTimeoutException(RemotingHelper.parseChannelRemoteAddr(channel), timeoutMillis, responseFuture.getCause());
                }
                throw new RemotingSendRequestException(RemotingHelper.parseChannelRemoteAddr(channel), responseFuture.getCause());
            }
            RemotingCommand remotingCommand = responseCommand;
            return remotingCommand;
        }
        finally {
            this.responseTable.remove(request.getOpaque());
        }
    }

    public void invokeAsyncImpl(final Channel channel, final RemotingCommand request, long timeoutMillis, AsyncCallback asyncCallback) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        boolean acquired = this.semaphoreAsync.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        if (acquired) {
            SemaphoreReleaseOnlyOnce once = new SemaphoreReleaseOnlyOnce(this.semaphoreAsync);
            final ResponseFuture responseFuture = new ResponseFuture(request.getOpaque(), timeoutMillis, asyncCallback, once);
            this.responseTable.put(request.getOpaque(), responseFuture);
            try {
                channel.writeAndFlush(request).addListener(new ChannelHandlerListener(){

                    @Override
                    public void operationComplete(Future future) throws Exception {
                        if (future.isSuccess()) {
                            responseFuture.setSendRequestOK(true);
                            return;
                        }
                        responseFuture.setSendRequestOK(false);
                        responseFuture.putResponse(null);
                        responseFuture.executeInvokeCallback();
                        AbstractRemoting.this.responseTable.remove(request.getOpaque());
                        LOGGER.warn("send a request command to channel <" + channel.remoteAddress() + "> failed.");
                        LOGGER.warn(request.toString());
                    }
                });
            }
            catch (Exception e) {
                once.release();
                LOGGER.warn("write send a request command to channel <" + channel.remoteAddress() + "> failed.");
                throw new RemotingSendRequestException(RemotingHelper.parseChannelRemoteAddr(channel), e);
            }
        } else {
            if (timeoutMillis <= 0L) {
                throw new RemotingTooMuchRequestException("invokeAsyncImpl invoke too fast");
            }
            LOGGER.warn("invokeAsyncImpl tryAcquire semaphore timeout, " + timeoutMillis + " waiting thread nums: " + this.semaphoreAsync.getQueueLength());
            LOGGER.warn(request.toString());
            throw new RemotingTimeoutException("tryAcquire timeout(ms) " + timeoutMillis);
        }
    }

    public void invokeOnewayImpl(final Channel channel, final RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        RemotingCommandHelper.markOnewayRPC(request);
        boolean acquired = this.semaphoreOneway.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        if (acquired) {
            final SemaphoreReleaseOnlyOnce once = new SemaphoreReleaseOnlyOnce(this.semaphoreOneway);
            try {
                channel.writeAndFlush(request).addListener(new ChannelHandlerListener(){

                    @Override
                    public void operationComplete(Future future) throws Exception {
                        once.release();
                        if (!future.isSuccess()) {
                            LOGGER.warn("send a request command to channel <" + channel.remoteAddress() + "> failed.");
                            LOGGER.warn(request.toString());
                        }
                    }
                });
            }
            catch (Exception e) {
                once.release();
                LOGGER.warn("write send a request command to channel <" + channel.remoteAddress() + "> failed.");
                throw new RemotingSendRequestException(RemotingHelper.parseChannelRemoteAddr(channel), e);
            }
        } else {
            if (timeoutMillis <= 0L) {
                throw new RemotingTooMuchRequestException("invokeOnewayImpl invoke too fast");
            }
            LOGGER.warn("invokeOnewayImpl tryAcquire semaphore timeout, " + timeoutMillis + " waiting thread nums: " + this.semaphoreOneway.getQueueLength());
            LOGGER.warn(request.toString());
            throw new RemotingTimeoutException("tryAcquire timeout(ms) " + timeoutMillis);
        }
    }

    protected Codec getCodec() {
        return new DefaultCodec();
    }

    class RemotingEventExecutor
    extends ServiceThread {
        private final LinkedBlockingQueue<RemotingEvent> eventQueue = new LinkedBlockingQueue();
        private final int MaxSize = 10000;

        RemotingEventExecutor() {
        }

        public void putRemotingEvent(RemotingEvent event) {
            if (this.eventQueue.size() <= 10000) {
                this.eventQueue.add(event);
            } else {
                LOGGER.warn("event queue size[{}] enough, so drop this event {}", this.eventQueue.size(), event.toString());
            }
        }

        @Override
        public void run() {
            LOGGER.info(this.getServiceName() + " service started");
            ChannelEventListener listener = AbstractRemoting.this.getChannelEventListener();
            while (!this.isStopped()) {
                try {
                    RemotingEvent event = this.eventQueue.poll(3000L, TimeUnit.MILLISECONDS);
                    if (event == null) continue;
                    switch (event.getType()) {
                        case ALL_IDLE: {
                            listener.onChannelIdle(IdleState.ALL_IDLE, event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case WRITER_IDLE: {
                            listener.onChannelIdle(IdleState.WRITER_IDLE, event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case READER_IDLE: {
                            listener.onChannelIdle(IdleState.READER_IDLE, event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case CLOSE: {
                            listener.onChannelClose(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case CONNECT: {
                            listener.onChannelConnect(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case EXCEPTION: {
                            listener.onChannelException(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.warn(this.getServiceName() + " service has exception. ", e);
                }
            }
            LOGGER.info(this.getServiceName() + " service end");
        }

        @Override
        public String getServiceName() {
            return RemotingEventExecutor.class.getSimpleName();
        }
    }
}

