/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting;

import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.remoting.AsyncCallback;
import com.github.ltsopensource.remoting.common.SemaphoreReleaseOnlyOnce;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ResponseFuture {
    private final int opaque;
    private final long timeoutMillis;
    private final AsyncCallback asyncCallback;
    private final long beginTimestamp = SystemClock.now();
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private final SemaphoreReleaseOnlyOnce once;
    private final AtomicBoolean executeCallbackOnlyOnce = new AtomicBoolean(false);
    private volatile RemotingCommand responseCommand;
    private volatile boolean sendRequestOK = true;
    private volatile Throwable cause;

    public ResponseFuture(int opaque, long timeoutMillis, AsyncCallback asyncCallback, SemaphoreReleaseOnlyOnce once) {
        this.opaque = opaque;
        this.timeoutMillis = timeoutMillis;
        this.asyncCallback = asyncCallback;
        this.once = once;
    }

    public void executeInvokeCallback() {
        if (this.asyncCallback != null && this.executeCallbackOnlyOnce.compareAndSet(false, true)) {
            this.asyncCallback.operationComplete(this);
        }
    }

    public void release() {
        if (this.once != null) {
            this.once.release();
        }
    }

    public boolean isTimeout() {
        long diff = SystemClock.now() - this.beginTimestamp;
        return diff > this.timeoutMillis;
    }

    public RemotingCommand waitResponse(long timeoutMillis) throws InterruptedException {
        this.countDownLatch.await(timeoutMillis, TimeUnit.MILLISECONDS);
        return this.responseCommand;
    }

    public void putResponse(RemotingCommand responseCommand) {
        this.responseCommand = responseCommand;
        this.countDownLatch.countDown();
    }

    public long getBeginTimestamp() {
        return this.beginTimestamp;
    }

    public boolean isSendRequestOK() {
        return this.sendRequestOK;
    }

    public void setSendRequestOK(boolean sendRequestOK) {
        this.sendRequestOK = sendRequestOK;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public AsyncCallback getAsyncCallback() {
        return this.asyncCallback;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public RemotingCommand getResponseCommand() {
        return this.responseCommand;
    }

    public void setResponseCommand(RemotingCommand responseCommand) {
        this.responseCommand = responseCommand;
    }

    public int getOpaque() {
        return this.opaque;
    }

    public String toString() {
        return "ResponseFuture [responseCommand=" + this.responseCommand + ", sendRequestOK=" + this.sendRequestOK + ", cause=" + this.cause + ", opaque=" + this.opaque + ", timeoutMillis=" + this.timeoutMillis + ", invokeCallback=" + this.asyncCallback + ", beginTimestamp=" + this.beginTimestamp + ", countDownLatch=" + this.countDownLatch + "]";
    }
}

