/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.protocol;

import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.remoting.RemotingCommandBody;
import com.github.ltsopensource.remoting.protocol.RemotingCommandHelper;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

public class RemotingCommand
implements Serializable {
    private static final long serialVersionUID = -6424506729433386206L;
    private static final AtomicInteger requestId = new AtomicInteger(0);
    private int code;
    private int subCode;
    private int version = 0;
    private int opaque;
    private int flag = 0;
    private String remark;
    private int sid = -1;
    private transient RemotingCommandBody body;

    private RemotingCommand() {
    }

    public static RemotingCommand createRequestCommand(int code, RemotingCommandBody body) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.setCode(code);
        cmd.setBody(body);
        cmd.setOpaque(requestId.getAndIncrement());
        return cmd;
    }

    public static RemotingCommand createResponseCommand(int code, String remark, RemotingCommandBody body) {
        RemotingCommand cmd = new RemotingCommand();
        RemotingCommandHelper.markResponseType(cmd);
        cmd.setCode(code);
        cmd.setRemark(remark);
        cmd.setBody(body);
        cmd.setOpaque(requestId.getAndIncrement());
        return cmd;
    }

    public static RemotingCommand createResponseCommand(int code, RemotingCommandBody body) {
        return RemotingCommand.createResponseCommand(code, null, body);
    }

    public static RemotingCommand createResponseCommand(int code) {
        return RemotingCommand.createResponseCommand(code, null, null);
    }

    public static RemotingCommand createResponseCommand(int code, String remark) {
        return RemotingCommand.createResponseCommand(code, remark, null);
    }

    public void setBody(RemotingCommandBody body) {
        this.body = body;
    }

    public <T extends RemotingCommandBody> T getBody() {
        return (T)this.body;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getOpaque() {
        return this.opaque;
    }

    public void setOpaque(int opaque) {
        this.opaque = opaque;
    }

    public int getFlag() {
        return this.flag;
    }

    public int getSubCode() {
        return this.subCode;
    }

    public void setSubCode(int subCode) {
        this.subCode = subCode;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public int getSid() {
        return this.sid;
    }

    public void setSid(int sid) {
        this.sid = sid;
    }

    public String toString() {
        return "RemotingCommand{code=" + this.code + ", subCode=" + this.subCode + ", version=" + this.version + ", opaque=" + this.opaque + ", flag=" + this.flag + ", remark='" + this.remark + '\'' + ", sid='" + this.sid + '\'' + ", body=" + JSON.toJSONString(this.body) + '}';
    }
}

