/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.serialize;

import com.alibaba.fastjson.JSON;
import com.github.ltsopensource.remoting.serialize.RemotingSerializable;
import java.nio.charset.Charset;

public class FastJsonSerializable
implements RemotingSerializable {
    @Override
    public int getId() {
        return 1;
    }

    @Override
    public byte[] serialize(Object obj) throws Exception {
        String json = this.toJson(obj, false);
        return json.getBytes(Charset.forName("UTF-8"));
    }

    @Override
    public <T> T deserialize(byte[] data, Class<T> clazz) throws Exception {
        String json = new String(data, Charset.forName("UTF-8"));
        return this.fromJson(json, clazz);
    }

    private String toJson(Object obj, boolean prettyFormat) {
        return JSON.toJSONString((Object)obj, (boolean)prettyFormat);
    }

    private <T> T fromJson(String json, Class<T> classOfT) {
        return (T)JSON.parseObject((String)json, classOfT);
    }
}

