/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.store.jdbc;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class TxConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TxConnectionFactory.class);
    private static final ThreadLocal<Connection> TRANSACT_CONN = new ThreadLocal();

    static Connection getCurrentConn() {
        return TRANSACT_CONN.get();
    }

    static Connection getTxConnection(DataSource dataSource) throws SQLException {
        Connection conn = TRANSACT_CONN.get();
        if (conn != null) {
            throw new IllegalStateException("Start second transaction in one thread");
        }
        conn = dataSource.getConnection();
        conn.setAutoCommit(false);
        TRANSACT_CONN.set(conn);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeTx(Connection conn) {
        try {
            if (conn != null) {
                if (conn.isReadOnly()) {
                    conn.setReadOnly(false);
                }
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), e);
        }
        finally {
            TRANSACT_CONN.set(null);
        }
    }
}

