/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.zookeeper.lts;

import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.registry.NodeRegistryUtils;
import com.github.ltsopensource.zookeeper.ChildListener;
import com.github.ltsopensource.zookeeper.DataListener;
import com.github.ltsopensource.zookeeper.lts.ZkException;
import com.github.ltsopensource.zookeeper.lts.ZkInterruptedException;
import com.github.ltsopensource.zookeeper.serializer.SerializableSerializer;
import com.github.ltsopensource.zookeeper.serializer.ZkSerializer;
import com.github.ltsopensource.zookeeper.support.AbstractZkClient;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class LtsZkClient
extends AbstractZkClient<ChildListener, DataListener>
implements Watcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(LtsZkClient.class);
    public static final int connectionTimeout = 30000;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition conditionNotConnect = this.lock.newCondition();
    private final Condition conditionConnected = this.lock.newCondition();
    private ZooKeeper zk;
    private volatile boolean isClosed = false;
    private String hosts;
    private volatile Watcher.Event.KeeperState state = Watcher.Event.KeeperState.SyncConnected;
    private ZkSerializer serializer = new SerializableSerializer();
    private final Map<String, Set<ChildListener>> childListeners = new ConcurrentHashMap<String, Set<ChildListener>>();

    public LtsZkClient(Config config) {
        this.hosts = NodeRegistryUtils.getRealRegistryAddress(config.getRegistryAddress());
        Thread guard = new Thread("zkClientGuard"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!LtsZkClient.this.isClosed) {
                    LtsZkClient.this.lock.lock();
                    try {
                        if (LtsZkClient.this.zk == null || !LtsZkClient.this.zk.getState().isAlive()) {
                            LOGGER.info("is not alive, try close before and new connect to zk");
                            LtsZkClient.this.tryReConnect();
                        }
                        LtsZkClient.this.conditionNotConnect.await(1000L, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        LOGGER.error("guard error, sleep 1000 to retry", e);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    finally {
                        LtsZkClient.this.lock.unlock();
                    }
                }
            }
        };
        guard.setDaemon(true);
        guard.start();
    }

    public void process(WatchedEvent event) {
        this.fireStateChanged(event);
        if (event.getType() == Watcher.Event.EventType.None) {
            if (Watcher.Event.KeeperState.SyncConnected == event.getState()) {
                LOGGER.info("connected signal from zk: " + this.hosts + ", sessionId=" + this.getSessionId() + ", sessionTimeout=" + this.getSessionTimeout());
                this.notifyConnected();
            } else if (Watcher.Event.KeeperState.Disconnected == event.getState()) {
                LOGGER.info("disconnected signal from zk: " + this.hosts + ", sessionId=" + this.getSessionId() + ", sessionTimeout=" + this.getSessionTimeout());
                this.notifyNotConnect();
            } else if (Watcher.Event.KeeperState.Expired == event.getState()) {
                LOGGER.info("expired signal from zk: " + this.hosts + ", sessionId=" + this.getSessionId() + ", sessionTimeout=" + this.getSessionTimeout());
                this.notifyNotConnect();
            }
        }
        this.childEventWatch(event);
    }

    private void fireStateChanged(WatchedEvent event) {
        this.state = event.getState();
        if (this.state == Watcher.Event.KeeperState.Disconnected) {
            this.stateChanged(0);
        } else if (this.state == Watcher.Event.KeeperState.SyncConnected) {
            this.stateChanged(1);
        } else if (this.state == Watcher.Event.KeeperState.Expired) {
            this.stateChanged(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void childEventWatch(WatchedEvent event) {
        if (event.getPath() == null) {
            return;
        }
        try {
            if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged || event.getType() == Watcher.Event.EventType.NodeCreated || event.getType() == Watcher.Event.EventType.NodeDeleted) {
                String path = event.getPath();
                this.fireChangeEvent(path, this.childListeners.get(path));
            }
        }
        finally {
            if (event.getState() == Watcher.Event.KeeperState.Expired) {
                for (Map.Entry<String, Set<ChildListener>> entry : this.childListeners.entrySet()) {
                    this.fireChangeEvent(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    private void fireChangeEvent(String path, Set<ChildListener> listeners) {
        if (listeners != null && !listeners.isEmpty()) {
            for (ChildListener listener : listeners) {
                try {
                    this.exists(path);
                    List<String> children = this.getChildren(path);
                    listener.childChanged(path, children);
                }
                catch (ZkException e) {
                    if (e.isZkNoNodeException()) {
                        listener.childChanged(path, null);
                        continue;
                    }
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConnected() {
        this.lock.lock();
        try {
            this.conditionConnected.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    private synchronized void tryReConnect() throws IOException {
        this.doClose0();
        this.zk = new ZooKeeper(this.hosts, 30000, (Watcher)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNotConnect() {
        this.lock.lock();
        try {
            this.conditionNotConnect.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void doClose() {
        this.isClosed = true;
        this.doClose0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose0() {
        if (this.zk != null) {
            try {
                this.zk.close();
            }
            catch (Exception e) {
                LOGGER.error("close error ", e);
            }
            finally {
                this.zk = null;
            }
        }
    }

    @Override
    protected String createPersistent(String path, boolean sequential) {
        return this.createPersistent(path, null, sequential);
    }

    @Override
    protected String createPersistent(String path, Object data, boolean sequential) {
        block8: {
            byte[] bytes;
            this.checkConnect();
            byte[] byArray = bytes = data == null ? null : this.serialize(data);
            if (sequential) {
                try {
                    return this.zk.create(path, bytes, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
                }
                catch (KeeperException e) {
                    throw new ZkException("path[\" + path + \"], sequential[true] , code:" + e.code(), e);
                }
                catch (InterruptedException e) {
                    throw new ZkInterruptedException("create persistent path[" + path + "], sequential[true]", e);
                }
            }
            try {
                this.zk.create(path, bytes, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                return path;
            }
            catch (KeeperException e) {
                if (this.isZkNodeExistsException(e)) break block8;
                if (this.isZkNoNodeException(e)) {
                    String parentDir = path.substring(0, path.lastIndexOf(47));
                    this.createPersistent(parentDir, false);
                    this.createPersistent(path, false);
                }
                throw new ZkException("path[\" + path + \"], sequential[false] , code:" + e.code(), e);
            }
            catch (InterruptedException e) {
                throw new ZkInterruptedException("create persistent path[" + path + "], sequential[false]", e);
            }
        }
        return null;
    }

    private byte[] serialize(Object data) {
        return this.serializer.serialize(data);
    }

    @Override
    protected String createEphemeral(String path, boolean sequential) {
        return this.createEphemeral(path, null, sequential);
    }

    @Override
    protected String createEphemeral(String path, Object data, boolean sequential) {
        byte[] bytes;
        this.checkConnect();
        byte[] byArray = bytes = data == null ? null : this.serialize(data);
        if (sequential) {
            try {
                return this.zk.create(path, bytes, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
            }
            catch (KeeperException e) {
                throw new ZkException("path[\" + path + \"], sequential[true] , code:" + e.code(), e);
            }
            catch (InterruptedException e) {
                throw new ZkInterruptedException("create ephemeral path[" + path + "], sequential[true]", e);
            }
        }
        try {
            this.zk.create(path, bytes, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            return path;
        }
        catch (KeeperException e) {
            if (!this.isZkNodeExistsException(e)) {
                throw new ZkException("path[\" + path + \"], sequential[false] , code:" + e.code(), e);
            }
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException("create ephemeral path[" + path + "], sequential[false]", e);
        }
        return null;
    }

    @Override
    protected ChildListener createTargetChildListener(String path, ChildListener listener) {
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<String> addTargetChildListener(String path, ChildListener childListener) {
        this.checkConnect();
        Map<String, Set<ChildListener>> map = this.childListeners;
        synchronized (map) {
            Set<ChildListener> listeners = this.childListeners.get(path);
            if (listeners == null) {
                listeners = new CopyOnWriteArraySet<ChildListener>();
                this.childListeners.put(path, listeners);
            }
            listeners.add(childListener);
        }
        try {
            this.zk.exists(path, true);
            try {
                return this.zk.getChildren(path, true);
            }
            catch (KeeperException e) {
                if (!this.isZkNoNodeException(e)) {
                    throw e;
                }
            }
        }
        catch (KeeperException e) {
            throw new ZkException(e);
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeTargetChildListener(String path, ChildListener childListener) {
        Map<String, Set<ChildListener>> map = this.childListeners;
        synchronized (map) {
            Set<ChildListener> listeners = this.childListeners.get(path);
            if (listeners != null) {
                listeners.remove(childListener);
            }
        }
    }

    @Override
    protected void addTargetDataListener(String path, DataListener listener) {
    }

    @Override
    protected DataListener createTargetDataListener(String path, DataListener listener) {
        return null;
    }

    @Override
    protected void removeTargetDataListener(String path, DataListener listener) {
    }

    @Override
    public boolean delete(String path) {
        try {
            this.zk.delete(path, -1);
            return true;
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        catch (KeeperException e) {
            if (this.isZkNoNodeException(e)) {
                return false;
            }
            throw new ZkException(e);
        }
    }

    private boolean isZkNoNodeException(KeeperException e) {
        return KeeperException.Code.NONODE == e.code();
    }

    private boolean isZkNodeExistsException(KeeperException e) {
        return KeeperException.Code.NODEEXISTS == e.code();
    }

    @Override
    public boolean exists(String path) {
        boolean watch = CollectionUtils.isNotEmpty((Collection)this.childListeners.get(path));
        try {
            return this.zk.exists(path, watch) != null;
        }
        catch (KeeperException e) {
            if (this.isZkNoNodeException(e)) {
                return false;
            }
            throw new ZkException(e);
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
    }

    @Override
    public <T> T getData(String path) {
        try {
            byte[] data = this.zk.getData(path, false, null);
            return (T)this.serializer.deserialize(data);
        }
        catch (KeeperException e) {
            throw new ZkException(e);
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
    }

    @Override
    public void setData(String path, Object data) {
        byte[] bytes = this.serializer.serialize(data);
        try {
            this.zk.setData(path, bytes, -1);
        }
        catch (KeeperException e) {
            throw new ZkException(e);
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
    }

    @Override
    public List<String> getChildren(String path) {
        boolean watch = CollectionUtils.isNotEmpty((Collection)this.childListeners.get(path));
        try {
            return this.zk.getChildren(path, watch);
        }
        catch (KeeperException e) {
            if (this.isZkNoNodeException(e)) {
                return null;
            }
            throw new ZkException(e);
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.state == Watcher.Event.KeeperState.SyncConnected;
    }

    public String getSessionId() {
        ZooKeeper current = this.zk;
        if (current != null) {
            return String.format("0x%x", current.getSessionId());
        }
        return "";
    }

    public long getSessionTimeout() {
        ZooKeeper current = this.zk;
        if (current != null) {
            return current.getSessionTimeout();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnect() {
        if (this.zk == null || !this.zk.getState().isConnected()) {
            this.lock.lock();
            try {
                this.conditionConnected.await(10000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.error(e);
            }
            finally {
                this.lock.unlock();
            }
            if (this.zk == null || !this.zk.getState().isConnected()) {
                throw new ZkException("zk not connected, please wait");
            }
        }
    }
}

