/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.autoconfigure;

import com.github.ltsopensource.autoconfigure.AutoConfigContext;
import com.github.ltsopensource.autoconfigure.PropertiesConfigurationResolveException;
import com.github.ltsopensource.autoconfigure.RelaxedNames;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AutoConfigContextBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoConfigContextBuilder.class);
    private Map<String, PropertyDescriptor> nameDescriptorMap;
    private Map<PropertyDescriptor, Set<String>> descriptorNameMap;
    private Object targetObj;
    private Map<String, String> propMap;
    private String prefix;
    private List<PropertyDescriptor> propertyDescriptors;

    public AutoConfigContextBuilder setTargetObj(Object targetObj) {
        this.targetObj = targetObj;
        return this;
    }

    public AutoConfigContextBuilder setPropMap(Map<String, String> propMap) {
        this.propMap = propMap;
        return this;
    }

    public AutoConfigContextBuilder setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public AutoConfigContext build() {
        this.buildPropertyDescriptors();
        this.buildNameDescriptorMap(this.prefix, this.propertyDescriptors);
        return new AutoConfigContext(this.nameDescriptorMap, this.descriptorNameMap, this.propMap, this.targetObj);
    }

    private void buildNameDescriptorMap(String prefix, List<PropertyDescriptor> propertyDescriptors) {
        RelaxedNames prefixes = StringUtils.hasLength(prefix) ? new RelaxedNames(prefix) : null;
        this.nameDescriptorMap = new LinkedHashMap<String, PropertyDescriptor>();
        this.descriptorNameMap = new HashMap<PropertyDescriptor, Set<String>>();
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            String name = descriptor.getName();
            if (name.equals("class")) continue;
            RelaxedNames relaxedNames = RelaxedNames.forCamelCase(name);
            if (prefixes == null) {
                for (String relaxedName : relaxedNames) {
                    this.nameDescriptorMap.put(relaxedName, descriptor);
                    Set<String> names = CollectionUtils.newHashSetOnNull(this.descriptorNameMap.get(descriptor));
                    names.add(relaxedName);
                    if (this.descriptorNameMap.containsKey(descriptor)) continue;
                    this.descriptorNameMap.put(descriptor, names);
                }
                continue;
            }
            for (String _prefix : prefixes) {
                for (String relaxedName : relaxedNames) {
                    String name1 = _prefix + "." + relaxedName;
                    String name2 = _prefix + "_" + relaxedName;
                    this.nameDescriptorMap.put(name1, descriptor);
                    this.nameDescriptorMap.put(name2, descriptor);
                    Set<String> names = CollectionUtils.newHashSetOnNull(this.descriptorNameMap.get(descriptor));
                    names.add(name1);
                    names.add(name2);
                    if (this.descriptorNameMap.containsKey(descriptor)) continue;
                    this.descriptorNameMap.put(descriptor, names);
                }
            }
        }
    }

    private void buildPropertyDescriptors() {
        this.propertyDescriptors = new ArrayList<PropertyDescriptor>();
        Class<?> clazz = this.targetObj.getClass();
        try {
            PropertyDescriptor[] pds;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz, 3);
            for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
                if (Class.class == clazz && ("classLoader".equals(pd.getName()) || "protectionDomain".equals(pd.getName()))) continue;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Found bean property '" + pd.getName() + "'" + (pd.getPropertyType() != null ? " of type [" + pd.getPropertyType().getName() + "]" : "") + (pd.getPropertyEditorClass() != null ? "; editor [" + pd.getPropertyEditorClass().getName() + "]" : ""));
                }
                this.propertyDescriptors.add(pd);
            }
        }
        catch (IntrospectionException e) {
            throw new PropertiesConfigurationResolveException(e);
        }
    }
}

