/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.autoconfigure.resolver;

import com.github.ltsopensource.autoconfigure.AutoConfigContext;
import com.github.ltsopensource.autoconfigure.PropertiesConfigurationResolveException;
import com.github.ltsopensource.autoconfigure.resolver.AbstractResolver;
import com.github.ltsopensource.core.commons.utils.PrimitiveTypeUtils;
import com.github.ltsopensource.core.json.JSON;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class ArrayResolver
extends AbstractResolver {
    public static final ArrayResolver INSTANCE = new ArrayResolver();

    @Override
    public void resolve(AutoConfigContext context, PropertyDescriptor descriptor, Class<?> propertyType) {
        Class<?> componentType = propertyType.getComponentType();
        Class<?> componentClass = propertyType.getComponentType();
        final HashMap kvMap = new HashMap();
        this.doFilter(context, descriptor, new AbstractResolver.Filter(){

            @Override
            public boolean onCondition(String name, String key, String value) {
                return key.startsWith(name);
            }

            @Override
            public boolean call(String name, String key, String value) {
                kvMap.put(key, value);
                return true;
            }
        });
        if (kvMap.size() > 0) {
            Object array = Array.newInstance(componentClass, kvMap.size());
            int index = 0;
            for (Map.Entry entry : kvMap.entrySet()) {
                String value = (String)entry.getValue();
                if (componentClass == Class.class) {
                    try {
                        Array.set(array, index++, Class.forName(value));
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new PropertiesConfigurationResolveException(e);
                    }
                }
                if (PrimitiveTypeUtils.isPrimitiveClass(componentClass)) {
                    Array.set(array, index++, PrimitiveTypeUtils.convert(value, componentClass));
                    continue;
                }
                Array.set(array, index++, JSON.parse(value, componentClass));
            }
            this.writeProperty(context, descriptor, array);
        }
    }
}

