/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.autoconfigure.resolver;

import com.github.ltsopensource.autoconfigure.AutoConfigContext;
import com.github.ltsopensource.autoconfigure.PropertiesConfigurationResolveException;
import com.github.ltsopensource.autoconfigure.resolver.AbstractResolver;
import java.beans.PropertyDescriptor;

public class ClassResolver
extends AbstractResolver {
    public static final ClassResolver INSTANCE = new ClassResolver();

    @Override
    public void resolve(final AutoConfigContext context, final PropertyDescriptor descriptor, Class<?> propertyType) {
        this.doFilter(context, descriptor, new AbstractResolver.Filter(){

            @Override
            public boolean onCondition(String name, String key, String value) {
                return key.equals(name);
            }

            @Override
            public boolean call(String name, String key, String value) {
                try {
                    Class<?> clazz = Class.forName(value);
                    ClassResolver.this.writeProperty(context, descriptor, clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new PropertiesConfigurationResolveException(e);
                }
                return false;
            }
        });
    }
}

