/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.biz.logger.mongo;

import com.github.ltsopensource.admin.response.PaginationRsp;
import com.github.ltsopensource.biz.logger.JobLogger;
import com.github.ltsopensource.biz.logger.domain.JobLogPo;
import com.github.ltsopensource.biz.logger.domain.JobLoggerRequest;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.store.mongo.MongoRepository;
import com.mongodb.DBCollection;
import java.util.Date;
import java.util.List;
import org.mongodb.morphia.query.Query;

public class MongoJobLogger
extends MongoRepository
implements JobLogger {
    public MongoJobLogger(Config config) {
        super(config);
        this.setTableName("lts_job_log_po");
        DBCollection dbCollection = this.template.getCollection();
        List indexInfo = dbCollection.getIndexInfo();
        if (CollectionUtils.sizeOf(indexInfo) <= 1) {
            this.template.ensureIndex("idx_logTime", "logTime");
            this.template.ensureIndex("idx_taskId_taskTrackerNodeGroup", "taskId,taskTrackerNodeGroup");
            this.template.ensureIndex("idx_realTaskId_taskTrackerNodeGroup", "realTaskId, taskTrackerNodeGroup");
        }
    }

    @Override
    public void log(JobLogPo jobLogPo) {
        this.template.save(jobLogPo);
    }

    @Override
    public void log(List<JobLogPo> jobLogPos) {
        this.template.save(jobLogPos);
    }

    @Override
    public PaginationRsp<JobLogPo> search(JobLoggerRequest request) {
        Query<JobLogPo> query = this.template.createQuery(JobLogPo.class);
        if (StringUtils.isNotEmpty(request.getTaskId())) {
            query.field("taskId").equal((Object)request.getTaskId());
        }
        if (StringUtils.isNotEmpty(request.getTaskTrackerNodeGroup())) {
            query.field("taskTrackerNodeGroup").equal((Object)request.getTaskTrackerNodeGroup());
        }
        if (request.getStartLogTime() != null) {
            query.filter("logTime >= ", (Object)this.getTimestamp(request.getStartLogTime()));
        }
        if (request.getEndLogTime() != null) {
            query.filter("logTime <= ", (Object)this.getTimestamp(request.getEndLogTime()));
        }
        PaginationRsp<JobLogPo> paginationRsp = new PaginationRsp<JobLogPo>();
        Long results = this.template.getCount(query);
        paginationRsp.setResults(results.intValue());
        if (results == 0L) {
            return paginationRsp;
        }
        query.order("-logTime").offset(request.getStart().intValue()).limit(request.getLimit().intValue());
        paginationRsp.setRows(query.asList());
        return paginationRsp;
    }

    private Long getTimestamp(Date timestamp) {
        if (timestamp == null) {
            return null;
        }
        return timestamp.getTime();
    }
}

