/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.biz.logger.mysql;

import com.github.ltsopensource.admin.response.PaginationRsp;
import com.github.ltsopensource.biz.logger.JobLogger;
import com.github.ltsopensource.biz.logger.domain.JobLogPo;
import com.github.ltsopensource.biz.logger.domain.JobLoggerRequest;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.queue.mysql.support.RshHolder;
import com.github.ltsopensource.store.jdbc.JdbcAbstractAccess;
import com.github.ltsopensource.store.jdbc.builder.InsertSql;
import com.github.ltsopensource.store.jdbc.builder.OrderByType;
import com.github.ltsopensource.store.jdbc.builder.SelectSql;
import com.github.ltsopensource.store.jdbc.builder.WhereSql;
import com.github.ltsopensource.store.jdbc.dbutils.JdbcTypeUtils;
import java.util.List;

public class MysqlJobLogger
extends JdbcAbstractAccess
implements JobLogger {
    public MysqlJobLogger(Config config) {
        super(config);
        this.createTable(this.readSqlFile("sql/mysql/lts_job_log_po.sql"));
    }

    @Override
    public void log(JobLogPo jobLogPo) {
        if (jobLogPo == null) {
            return;
        }
        InsertSql insertSql = this.buildInsertSql();
        this.setInsertSqlValues(insertSql, jobLogPo).doInsert();
    }

    @Override
    public void log(List<JobLogPo> jobLogPos) {
        if (CollectionUtils.isEmpty(jobLogPos)) {
            return;
        }
        InsertSql insertSql = this.buildInsertSql();
        for (JobLogPo jobLogPo : jobLogPos) {
            this.setInsertSqlValues(insertSql, jobLogPo);
        }
        insertSql.doBatchInsert();
    }

    private InsertSql buildInsertSql() {
        return new InsertSql(this.getSqlTemplate()).insert(this.getTableName()).columns("log_time", "gmt_created", "log_type", "success", "msg", "task_tracker_identity", "level", "task_id", "real_task_id", "job_id", "job_type", "priority", "submit_node_group", "task_tracker_node_group", "ext_params", "internal_ext_params", "need_feedback", "cron_expression", "trigger_time", "retry_times", "max_retry_times", "rely_on_prev_cycle", "repeat_count", "repeated_count", "repeat_interval");
    }

    private InsertSql setInsertSqlValues(InsertSql insertSql, JobLogPo jobLogPo) {
        return insertSql.values(jobLogPo.getLogTime(), jobLogPo.getGmtCreated(), jobLogPo.getLogType().name(), jobLogPo.isSuccess(), jobLogPo.getMsg(), jobLogPo.getTaskTrackerIdentity(), jobLogPo.getLevel().name(), jobLogPo.getTaskId(), jobLogPo.getRealTaskId(), jobLogPo.getJobId(), jobLogPo.getJobType() == null ? null : jobLogPo.getJobType().name(), jobLogPo.getPriority(), jobLogPo.getSubmitNodeGroup(), jobLogPo.getTaskTrackerNodeGroup(), JSON.toJSONString(jobLogPo.getExtParams()), JSON.toJSONString(jobLogPo.getInternalExtParams()), jobLogPo.isNeedFeedback(), jobLogPo.getCronExpression(), jobLogPo.getTriggerTime(), jobLogPo.getRetryTimes(), jobLogPo.getMaxRetryTimes(), jobLogPo.getDepPreCycle(), jobLogPo.getRepeatCount(), jobLogPo.getRepeatedCount(), jobLogPo.getRepeatInterval());
    }

    @Override
    public PaginationRsp<JobLogPo> search(JobLoggerRequest request) {
        PaginationRsp<JobLogPo> response = new PaginationRsp<JobLogPo>();
        Long results = (Long)new SelectSql(this.getSqlTemplate()).select().columns("count(1)").from().table(this.getTableName()).whereSql(this.buildWhereSql(request)).single();
        response.setResults(results.intValue());
        if (results == 0L) {
            return response;
        }
        List rows = new SelectSql(this.getSqlTemplate()).select().all().from().table(this.getTableName()).whereSql(this.buildWhereSql(request)).orderBy().column("log_time", OrderByType.DESC).limit(request.getStart(), request.getLimit()).list(RshHolder.JOB_LOGGER_LIST_RSH);
        response.setRows(rows);
        return response;
    }

    private WhereSql buildWhereSql(JobLoggerRequest request) {
        return new WhereSql().andOnNotEmpty("task_id = ?", request.getTaskId()).andOnNotEmpty("real_task_id = ?", request.getRealTaskId()).andOnNotEmpty("task_tracker_node_group = ?", request.getTaskTrackerNodeGroup()).andBetween("log_time", JdbcTypeUtils.toTimestamp(request.getStartLogTime()), JdbcTypeUtils.toTimestamp(request.getEndLogTime()));
    }

    private String getTableName() {
        return "lts_job_log_po";
    }
}

