/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.cluster;

import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.constant.Constants;
import com.github.ltsopensource.core.json.JSON;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Config
implements Serializable {
    private static final long serialVersionUID = -8283382582968938472L;
    private boolean available = true;
    private String nodeGroup;
    private String identity;
    private int workThreads;
    private NodeType nodeType;
    private String registryAddress;
    private int invokeTimeoutMillis;
    private int listenPort;
    private String ip;
    private String dataPath;
    private String clusterName;
    private volatile transient Map<String, Number> numbers;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final Map<String, Object> internalData = new ConcurrentHashMap<String, Object>();

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getNodeGroup() {
        return this.nodeGroup;
    }

    public void setNodeGroup(String nodeGroup) {
        this.nodeGroup = nodeGroup;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public int getWorkThreads() {
        return this.workThreads;
    }

    public void setWorkThreads(int workThreads) {
        this.workThreads = workThreads;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public String getRegistryAddress() {
        return this.registryAddress;
    }

    public void setRegistryAddress(String registryAddress) {
        this.registryAddress = registryAddress;
    }

    public int getInvokeTimeoutMillis() {
        return this.invokeTimeoutMillis;
    }

    public void setInvokeTimeoutMillis(int invokeTimeoutMillis) {
        this.invokeTimeoutMillis = invokeTimeoutMillis;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public void setParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public String getParameter(String key, String defaultValue) {
        String value = this.parameters.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    private Map<String, Number> getNumbers() {
        if (this.numbers == null) {
            this.numbers = new ConcurrentHashMap<String, Number>();
        }
        return this.numbers;
    }

    public boolean getParameter(String key, boolean defaultValue) {
        String value = this.getParameter(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public int getParameter(String key, int defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.intValue();
        }
        String value = this.getParameter(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        int i = Integer.parseInt(value);
        this.getNumbers().put(key, i);
        return i;
    }

    public String[] getParameter(String key, String[] defaultValue) {
        String value = this.getParameter(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return Constants.COMMA_SPLIT_PATTERN.split(value);
    }

    public double getParameter(String key, double defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.doubleValue();
        }
        String value = this.getParameter(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        double d = Double.parseDouble(value);
        this.getNumbers().put(key, d);
        return d;
    }

    public float getParameter(String key, float defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.floatValue();
        }
        String value = this.getParameter(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        float f = Float.parseFloat(value);
        this.getNumbers().put(key, Float.valueOf(f));
        return f;
    }

    public long getParameter(String key, long defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.longValue();
        }
        String value = this.getParameter(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        long l = Long.parseLong(value);
        this.getNumbers().put(key, l);
        return l;
    }

    public short getParameter(String key, short defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.shortValue();
        }
        String value = this.getParameter(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        short s = Short.parseShort(value);
        this.getNumbers().put(key, s);
        return s;
    }

    public byte getParameter(String key, byte defaultValue) {
        Number n = this.getNumbers().get(key);
        if (n != null) {
            return n.byteValue();
        }
        String value = this.getParameter(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        byte b = Byte.parseByte(value);
        this.getNumbers().put(key, b);
        return b;
    }

    public <T> T getInternalData(String key, T defaultValue) {
        Object obj = this.internalData.get(key);
        if (obj == null) {
            return defaultValue;
        }
        return (T)obj;
    }

    public <T> T getInternalData(String key) {
        return this.getInternalData(key, null);
    }

    public void setInternalData(String key, Object value) {
        this.internalData.put(key, value);
    }

    public String toString() {
        return JSON.toJSONString(this);
    }
}

