/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.cluster;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.listener.MasterChangeListener;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.ec.EventInfo;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;

public class MasterElector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MasterElector.class);
    private AppContext appContext;
    private List<MasterChangeListener> listeners;
    private Node master;
    private ReentrantLock lock = new ReentrantLock();

    public MasterElector(AppContext appContext) {
        this.appContext = appContext;
    }

    public void addMasterChangeListener(List<MasterChangeListener> masterChangeListeners) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<MasterChangeListener>();
        }
        if (CollectionUtils.isNotEmpty(masterChangeListeners)) {
            this.listeners.addAll(masterChangeListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodes(List<Node> nodes) {
        this.lock.lock();
        try {
            Node newMaster = null;
            for (Node node : nodes) {
                if (newMaster == null) {
                    newMaster = node;
                    continue;
                }
                if (newMaster.getCreateTime() <= node.getCreateTime()) continue;
                newMaster = node;
            }
            this.addNode(newMaster);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isCurrentMaster() {
        return this.master != null && this.master.getIdentity().equals(this.appContext.getConfig().getIdentity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(Node newNode) {
        this.lock.lock();
        try {
            if (this.master == null) {
                this.master = newNode;
                this.notifyListener();
            } else if (this.master.getCreateTime() > newNode.getCreateTime()) {
                this.master = newNode;
                this.notifyListener();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(List<Node> removedNodes) {
        this.lock.lock();
        try {
            if (this.master != null) {
                List<Node> nodes;
                boolean masterRemoved = false;
                for (Node removedNode : removedNodes) {
                    if (!this.master.getIdentity().equals(removedNode.getIdentity())) continue;
                    masterRemoved = true;
                }
                if (masterRemoved && CollectionUtils.isNotEmpty(nodes = this.appContext.getSubscribedNodeManager().getNodeList(this.appContext.getConfig().getNodeType(), this.appContext.getConfig().getNodeGroup()))) {
                    Node newMaster = null;
                    for (Node node : nodes) {
                        if (newMaster == null) {
                            newMaster = node;
                            continue;
                        }
                        if (newMaster.getCreateTime() <= node.getCreateTime()) continue;
                        newMaster = node;
                    }
                    this.master = newMaster;
                    this.notifyListener();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void notifyListener() {
        boolean isMaster = false;
        if (this.appContext.getConfig().getIdentity().equals(this.master.getIdentity())) {
            LOGGER.info("Current node become the master node:{}", this.master);
            isMaster = true;
        } else {
            LOGGER.info("Master node is :{}", this.master);
            isMaster = false;
        }
        if (this.listeners != null) {
            for (MasterChangeListener masterChangeListener : this.listeners) {
                try {
                    masterChangeListener.change(this.master, isMaster);
                }
                catch (Throwable t) {
                    LOGGER.error("MasterChangeListener notify error!", t);
                }
            }
        }
        EventInfo eventInfo = new EventInfo("MASTER_CHANGED");
        eventInfo.setParam("master", this.master);
        this.appContext.getEventCenter().publishSync(eventInfo);
    }
}

