/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.commons.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SerialKiller
extends ObjectInputStream {
    private String[] blacklist = new String[]{"org.apache.commons.collections.functors.InvokerTransformer$", "org.apache.commons.collections.functors.InstantiateTransformer$", "org.apache.commons.collections4.functors.InvokerTransformer$", "org.apache.commons.collections4.functors.InstantiateTransformer$", "org.codehaus.groovy.runtime.ConvertedClosure$", "org.codehaus.groovy.runtime.MethodClosure$", "org.springframework.beans.factory.ObjectFactory$"};
    private String[] whitelist = new String[]{".*"};

    public SerialKiller(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass serialInput) throws IOException, ClassNotFoundException {
        for (String blackRegExp : this.blacklist) {
            Pattern blackPattern = Pattern.compile(blackRegExp);
            Matcher blackMatcher = blackPattern.matcher(serialInput.getName());
            if (!blackMatcher.find()) continue;
            throw new InvalidClassException("[!] Blocked by SerialKiller's blacklist '" + blackRegExp + "'. Match found for '" + serialInput.getName() + "'");
        }
        boolean safeClass = false;
        for (String whiteRegExp : this.whitelist) {
            Pattern whitePattern = Pattern.compile(whiteRegExp);
            Matcher whiteMatcher = whitePattern.matcher(serialInput.getName());
            if (!whiteMatcher.find()) continue;
            safeClass = true;
        }
        if (!safeClass) {
            throw new InvalidClassException("[!] Blocked by SerialKiller's whitelist. No match found for '" + serialInput.getName() + "'");
        }
        return super.resolveClass(serialInput);
    }
}

