/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.commons.utils;

import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchUtils {
    private static <E> List<E> getBatchList(Integer index, int batchSize, Collection<E> collection) {
        ArrayList<E> list = null;
        list = collection instanceof List ? (ArrayList<E>)collection : new ArrayList<E>(collection);
        if (index == list.size() / batchSize) {
            return list.subList(index * batchSize, list.size());
        }
        return list.subList(index * batchSize, (index + 1) * batchSize);
    }

    public static <E> void batchExecute(int totalSize, int batchSize, Collection<E> collection, Executor<E> executor) {
        List<E> list;
        for (int i = 0; i <= totalSize / batchSize && (!CollectionUtils.isNotEmpty(list = BatchUtils.getBatchList(i, batchSize, collection)) || executor.execute(list)); ++i) {
        }
    }

    public static interface Executor<E> {
        public boolean execute(List<E> var1);
    }
}

