/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.compiler;

import com.github.ltsopensource.core.commons.utils.ClassHelper;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.compiler.Compiler;
import com.github.ltsopensource.core.compiler.JavassistCompiler;
import com.github.ltsopensource.core.compiler.JdkCompiler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractCompiler
implements Compiler {
    private static Compiler COMPILER;
    private static final Pattern PACKAGE_PATTERN;
    private static final Pattern CLASS_PATTERN;

    public static void setCompiler(Compiler compiler) {
        if (compiler == null) {
            throw new IllegalArgumentException("compiler should not be null");
        }
        COMPILER = compiler;
    }

    public static Compiler getCompiler() {
        if (COMPILER == null) {
            COMPILER = new JavassistCompiler();
        }
        return COMPILER;
    }

    public static void setCompiler(String compiler) {
        if ("javassist".equals(compiler)) {
            AbstractCompiler.setCompiler(new JavassistCompiler());
        } else if ("jdk".equals(compiler)) {
            AbstractCompiler.setCompiler(new JdkCompiler());
        } else {
            throw new IllegalArgumentException("compiler[" + compiler + "] error ");
        }
    }

    @Override
    public Class<?> compile(String code) {
        Matcher matcher = PACKAGE_PATTERN.matcher(code = code.trim());
        String pkg = matcher.find() ? matcher.group(1) : "";
        matcher = CLASS_PATTERN.matcher(code);
        if (!matcher.find()) {
            throw new IllegalArgumentException("No such class name in " + code);
        }
        String cls = matcher.group(1);
        String className = pkg != null && pkg.length() > 0 ? pkg + "." + cls : cls;
        try {
            return Class.forName(className, true, ClassHelper.getCallerClassLoader(this.getClass()));
        }
        catch (ClassNotFoundException e) {
            if (!code.endsWith("}")) {
                throw new IllegalStateException("The java code not endsWith \"}\", code: " + code + "");
            }
            try {
                return this.doCompile(className, code);
            }
            catch (RuntimeException t) {
                throw t;
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to compile class, cause: " + t.getMessage() + ", class: " + className + ", code: " + code + ", stack: " + StringUtils.toString(t));
            }
        }
    }

    protected abstract Class<?> doCompile(String var1, String var2) throws Throwable;

    static {
        PACKAGE_PATTERN = Pattern.compile("package\\s+([$_a-zA-Z][$_a-zA-Z0-9\\.]*);");
        CLASS_PATTERN = Pattern.compile("class\\s+([$_a-zA-Z][$_a-zA-Z0-9]*)\\s+");
    }
}

