/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.failstore;

import com.github.ltsopensource.core.commons.file.FileLock;
import com.github.ltsopensource.core.commons.file.FileUtils;
import com.github.ltsopensource.core.failstore.FailStore;
import com.github.ltsopensource.core.failstore.FailStoreException;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFailStore
implements FailStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(FailStore.class);
    protected FileLock fileLock;
    private String home;
    protected File dbPath;
    private static final String dbLockName = "___db.lock";

    public AbstractFailStore(File dbPath, boolean needLock) {
        try {
            this.dbPath = dbPath;
            String path = dbPath.getPath();
            this.home = path.substring(0, path.indexOf(this.getName())).concat(this.getName());
            if (needLock) {
                this.getLock(dbPath.getPath());
            }
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getLock(String failStorePath) throws IOException {
        FileUtils.createDirIfNotExist(failStorePath);
        this.fileLock = new FileLock(failStorePath.concat("/").concat(dbLockName));
        boolean locked = this.fileLock.tryLock();
        if (!locked) {
            throw new IllegalStateException("can not get current file lock.");
        }
        LOGGER.info("Current failStore path is {}", failStorePath);
        return failStorePath;
    }

    public List<FailStore> getDeadFailStores() {
        File homeDir = new File(this.home);
        File[] subFiles = homeDir.listFiles();
        ArrayList<FailStore> deadFailStores = new ArrayList<FailStore>();
        if (subFiles != null && subFiles.length != 0) {
            for (File subFile : subFiles) {
                try {
                    FileLock tmpLock;
                    boolean locked;
                    if (!subFile.isDirectory() || !(locked = (tmpLock = new FileLock(subFile.getPath().concat("/").concat(dbLockName))).tryLock())) continue;
                    FailStore failStore = this.getFailStore(subFile);
                    if (failStore != null) {
                        deadFailStores.add(failStore);
                    }
                    tmpLock.release();
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), e);
                }
            }
        }
        return deadFailStores;
    }

    private FailStore getFailStore(File dbPath) {
        try {
            Constructor<?> constructor = this.getClass().getConstructor(File.class, Boolean.TYPE);
            return (FailStore)constructor.newInstance(dbPath, false);
        }
        catch (Exception e) {
            LOGGER.error("new instance failStore failed,", e);
            return null;
        }
    }

    protected abstract void init() throws FailStoreException;

    protected abstract String getName();

    @Override
    public String getPath() {
        return this.dbPath.getPath();
    }
}

