/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.json;

import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.json.JSONAdapter;
import com.github.ltsopensource.core.json.JSONException;
import com.github.ltsopensource.core.json.fastjson.FastJSONAdapter;
import com.github.ltsopensource.core.json.jackson.JacksonJSONAdapter;
import com.github.ltsopensource.core.json.ltsjson.LtsJSONAdapter;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.spi.ServiceLoader;

public class JSONFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONFactory.class);
    private static volatile JSONAdapter JSON_ADAPTER;

    public static void setJSONAdapter(String jsonAdapter) {
        if (StringUtils.isNotEmpty(jsonAdapter)) {
            JSONFactory.setJSONAdapter(ServiceLoader.load(JSONAdapter.class, jsonAdapter));
        }
    }

    public static JSONAdapter getJSONAdapter() {
        return JSON_ADAPTER;
    }

    public static void setJSONAdapter(JSONAdapter jsonAdapter) {
        if (jsonAdapter != null) {
            LOGGER.info("Using JSON lib " + jsonAdapter.getName());
            JSON_ADAPTER = jsonAdapter;
        }
    }

    static {
        String json = System.getProperty("lts.json");
        if ("fastjson".equals(json)) {
            JSONFactory.setJSONAdapter(new FastJSONAdapter());
        } else if ("jackson".equals(json)) {
            JSONFactory.setJSONAdapter(new JacksonJSONAdapter());
        } else {
            try {
                JSONFactory.setJSONAdapter(new FastJSONAdapter());
            }
            catch (Throwable ignored) {
                try {
                    JSONFactory.setJSONAdapter(new JacksonJSONAdapter());
                }
                catch (Throwable ignored2) {
                    try {
                        JSONFactory.setJSONAdapter(new LtsJSONAdapter());
                    }
                    catch (Throwable ignored3) {
                        throw new JSONException("Please check JSON lib");
                    }
                }
            }
        }
    }
}

