/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.json.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.ltsopensource.core.json.JSONAdapter;
import com.github.ltsopensource.core.json.JSONArray;
import com.github.ltsopensource.core.json.JSONException;
import com.github.ltsopensource.core.json.JSONObject;
import com.github.ltsopensource.core.json.TypeReference;
import com.github.ltsopensource.core.json.jackson.JacksonJSONArray;
import com.github.ltsopensource.core.json.jackson.JacksonJSONObject;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JacksonJSONAdapter
implements JSONAdapter {
    private ObjectMapper mapper = new ObjectMapper();

    public JacksonJSONAdapter() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public String getName() {
        return "jackson";
    }

    @Override
    public <T> T parse(String json, Type type) {
        try {
            return (T)this.mapper.readValue(json, this.mapper.getTypeFactory().constructType(type));
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    @Override
    public String toJSONString(Object obj) {
        try {
            return this.mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new JSONException(e);
        }
    }

    @Override
    public JSONObject toJSONObject(Object obj) {
        Map map = (Map)this.mapper.convertValue(obj, (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<HashMap<String, Object>>(){});
        return new JacksonJSONObject(map);
    }

    @Override
    public JSONArray toJSONArray(Object obj) {
        List list = (List)this.mapper.convertValue(obj, (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<List<Object>>(){});
        return new JacksonJSONArray(list);
    }

    @Override
    public JSONArray parseArray(String json) {
        List list = (List)this.parse(json, new TypeReference<List<Object>>(){}.getType());
        return new JacksonJSONArray(list);
    }

    @Override
    public JSONObject parseObject(String json) {
        Map map = (Map)this.parse(json, new TypeReference<Map<String, Object>>(){}.getType());
        return new JacksonJSONObject(map);
    }

    @Override
    public JSONObject newJSONObject() {
        return new JacksonJSONObject();
    }

    @Override
    public JSONObject newJSONObject(Map<String, Object> map) {
        return new JacksonJSONObject(map);
    }

    @Override
    public JSONObject newJSONObject(int initialCapacity) {
        return new JacksonJSONObject(initialCapacity);
    }

    @Override
    public JSONArray newJSONArray() {
        return new JacksonJSONArray();
    }

    @Override
    public JSONArray newJSONArray(List<Object> list) {
        return new JacksonJSONArray(list);
    }

    @Override
    public JSONArray newJSONArray(int initialCapacity) {
        return new JacksonJSONArray(initialCapacity);
    }
}

