/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.json.jackson;

import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.json.JSONArray;
import com.github.ltsopensource.core.json.JSONObject;
import com.github.ltsopensource.core.json.TypeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JacksonJSONObject
implements JSONObject {
    private final Map<String, Object> map;

    public JacksonJSONObject() {
        this(16);
    }

    public JacksonJSONObject(int initialCapacity) {
        this.map = new HashMap<String, Object>(initialCapacity);
    }

    public JacksonJSONObject(Map<String, Object> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(String key) {
        return this.map.get(key);
    }

    @Override
    public JSONObject getJSONObject(String key) {
        Object value = this.map.get(key);
        if (value instanceof JSONObject) {
            return (JSONObject)value;
        }
        return JSON.toJSONObject(value);
    }

    @Override
    public JSONArray getJSONArray(String key) {
        Object value = this.map.get(key);
        if (value instanceof JSONArray) {
            return (JSONArray)value;
        }
        return JSON.toJSONArray(value);
    }

    @Override
    public <T> T getObject(String key, Class<T> clazz) {
        Object value = this.map.get(key);
        return TypeUtils.castToJavaBean(value, clazz);
    }

    @Override
    public Boolean getBoolean(String key) {
        Object value = this.map.get(key);
        return TypeUtils.castToBoolean(value);
    }

    @Override
    public byte[] getBytes(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return TypeUtils.castToBytes(value);
    }

    @Override
    public boolean getBooleanValue(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return false;
        }
        return TypeUtils.castToBoolean(key);
    }

    @Override
    public Byte getByte(String key) {
        Object value = this.get(key);
        return TypeUtils.castToByte(value);
    }

    @Override
    public byte getByteValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0;
        }
        return TypeUtils.castToByte(value);
    }

    @Override
    public Short getShort(String key) {
        Object value = this.get(key);
        return TypeUtils.castToShort(value);
    }

    @Override
    public short getShortValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0;
        }
        return TypeUtils.castToShort(value);
    }

    @Override
    public Integer getInteger(String key) {
        Object value = this.get(key);
        return TypeUtils.castToInt(value);
    }

    @Override
    public int getIntValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0;
        }
        return TypeUtils.castToInt(value);
    }

    @Override
    public Long getLong(String key) {
        Object value = this.get(key);
        return TypeUtils.castToLong(value);
    }

    @Override
    public long getLongValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0L;
        }
        return TypeUtils.castToLong(value);
    }

    @Override
    public Float getFloat(String key) {
        Object value = this.get(key);
        return TypeUtils.castToFloat(value);
    }

    @Override
    public float getFloatValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0.0f;
        }
        return TypeUtils.castToFloat(value).floatValue();
    }

    @Override
    public Double getDouble(String key) {
        Object value = this.get(key);
        return TypeUtils.castToDouble(value);
    }

    @Override
    public double getDoubleValue(String key) {
        Object value = this.get(key);
        if (value == null) {
            return 0.0;
        }
        return TypeUtils.castToDouble(value);
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        Object value = this.get(key);
        return TypeUtils.castToBigDecimal(value);
    }

    @Override
    public BigInteger getBigInteger(String key) {
        Object value = this.get(key);
        return TypeUtils.castToBigInteger(value);
    }

    @Override
    public String getString(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public java.util.Date getDate(String key) {
        Object value = this.get(key);
        return TypeUtils.castToDate(value);
    }

    @Override
    public Date getSqlDate(String key) {
        Object value = this.get(key);
        return TypeUtils.castToSqlDate(value);
    }

    @Override
    public Timestamp getTimestamp(String key) {
        Object value = this.get(key);
        return TypeUtils.castToTimestamp(value);
    }

    @Override
    public Object put(String key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Object remove(String key) {
        return this.map.remove(key);
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public String toJSONString() {
        return JSON.toJSONString(this.map);
    }

    @Override
    public String toString() {
        return this.toJSONString();
    }
}

