/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.listener;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.listener.NodeChangeListener;
import com.github.ltsopensource.ec.EventInfo;
import java.util.List;

public class SelfChangeListener
implements NodeChangeListener {
    private Config config;
    private AppContext appContext;

    public SelfChangeListener(AppContext appContext) {
        this.config = appContext.getConfig();
        this.appContext = appContext;
    }

    private void change(Node node) {
        if (node.getIdentity().equals(this.config.getIdentity())) {
            if (node.getNodeType().equals((Object)NodeType.TASK_TRACKER) && node.getThreads().intValue() != this.config.getWorkThreads()) {
                this.config.setWorkThreads(node.getThreads());
                this.appContext.getEventCenter().publishAsync(new EventInfo("WORK_THREAD_CHANGE"));
            }
            if (node.isAvailable() != this.config.isAvailable()) {
                String topic = node.isAvailable() ? "NODE_ENABLE" : "NODE_DISABLE";
                this.config.setAvailable(node.isAvailable());
                this.appContext.getEventCenter().publishAsync(new EventInfo(topic));
            }
        }
    }

    @Override
    public void addNodes(List<Node> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        for (Node node : nodes) {
            this.change(node);
        }
    }

    @Override
    public void removeNodes(List<Node> nodes) {
    }
}

