/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.properties;

import com.github.ltsopensource.autoconfigure.annotation.ConfigurationProperties;
import com.github.ltsopensource.core.cluster.AbstractConfigProperties;
import com.github.ltsopensource.core.commons.utils.Assert;
import com.github.ltsopensource.core.constant.Level;
import com.github.ltsopensource.core.exception.ConfigPropertiesIllegalException;

@ConfigurationProperties(prefix="lts.tasktracker")
public class TaskTrackerProperties
extends AbstractConfigProperties {
    private String nodeGroup;
    private String dataPath;
    private int workThreads;
    private Level bizLoggerLevel;
    private DispatchRunner dispatchRunner;
    private Class<?> jobRunnerClass;

    public String getNodeGroup() {
        return this.nodeGroup;
    }

    public void setNodeGroup(String nodeGroup) {
        this.nodeGroup = nodeGroup;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public int getWorkThreads() {
        return this.workThreads;
    }

    public void setWorkThreads(int workThreads) {
        this.workThreads = workThreads;
    }

    public Class<?> getJobRunnerClass() {
        return this.jobRunnerClass;
    }

    public void setJobRunnerClass(Class<?> jobRunnerClass) {
        this.jobRunnerClass = jobRunnerClass;
    }

    public Level getBizLoggerLevel() {
        return this.bizLoggerLevel;
    }

    public void setBizLoggerLevel(Level bizLoggerLevel) {
        this.bizLoggerLevel = bizLoggerLevel;
    }

    public DispatchRunner getDispatchRunner() {
        return this.dispatchRunner;
    }

    public void setDispatchRunner(DispatchRunner dispatchRunner) {
        this.dispatchRunner = dispatchRunner;
    }

    @Override
    public void checkProperties() throws ConfigPropertiesIllegalException {
        Assert.hasText(this.getClusterName(), "clusterName must have value.");
        Assert.hasText(this.getNodeGroup(), "nodeGroup must have value.");
        Assert.hasText(this.getRegistryAddress(), "registryAddress must have value.");
        Assert.isTrue(this.getWorkThreads() >= 0, "workThreads must >= 0.");
    }

    public static class DispatchRunner {
        private boolean enable = false;
        private String shardValue;

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public String getShardValue() {
            return this.shardValue;
        }

        public void setShardValue(String shardValue) {
            this.shardValue = shardValue;
        }
    }
}

