/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.registry;

import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;

public class NodeRegistryUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeRegistryUtils.class);

    public static String getRootPath(String clusterName) {
        return "/LTS/" + clusterName + "/NODES";
    }

    public static String getNodeTypePath(String clusterName, NodeType nodeType) {
        return NodeRegistryUtils.getRootPath(clusterName) + "/" + (Object)((Object)nodeType);
    }

    public static Node parse(String fullPath) {
        try {
            String[] paramArr;
            String port;
            Node node = new Node();
            String[] nodeDir = fullPath.split("/");
            NodeType nodeType = NodeType.valueOf(nodeDir[4]);
            node.setNodeType(nodeType);
            String url = nodeDir[5];
            url = url.substring(nodeType.name().length() + 3);
            String address = url.split("\\?")[0];
            String ip = address.split(":")[0];
            node.setIp(ip);
            if (address.contains(":") && (port = address.split(":")[1]) != null && !"".equals(port.trim())) {
                node.setPort(Integer.valueOf(port));
            }
            String params = url.split("\\?")[1];
            for (String paramEntry : paramArr = params.split("&")) {
                if (StringUtils.isEmpty(paramEntry)) continue;
                String key = paramEntry.split("=")[0];
                String value = paramEntry.split("=")[1];
                if ("clusterName".equals(key)) {
                    node.setClusterName(value);
                    continue;
                }
                if ("group".equals(key)) {
                    node.setGroup(value);
                    continue;
                }
                if ("threads".equals(key)) {
                    node.setThreads(Integer.valueOf(value));
                    continue;
                }
                if ("identity".equals(key)) {
                    node.setIdentity(value);
                    continue;
                }
                if ("createTime".equals(key)) {
                    node.setCreateTime(Long.valueOf(value));
                    continue;
                }
                if ("isAvailable".equals(key)) {
                    node.setAvailable(Boolean.valueOf(value));
                    continue;
                }
                if ("hostName".equals(key)) {
                    node.setHostName(value);
                    continue;
                }
                if (!"httpCmdPort".equals(key)) continue;
                node.setHttpCmdPort(Integer.valueOf(value));
            }
            return node;
        }
        catch (RuntimeException e) {
            LOGGER.error("Error parse node , path:" + fullPath);
            throw e;
        }
    }

    public static String getFullPath(Node node) {
        StringBuilder path = new StringBuilder();
        path.append(NodeRegistryUtils.getRootPath(node.getClusterName())).append("/").append((Object)node.getNodeType()).append("/").append((Object)node.getNodeType()).append(":\\\\").append(node.getIp());
        if (node.getPort() != null && node.getPort() != 0) {
            path.append(":").append(node.getPort());
        }
        path.append("?").append("group=").append(node.getGroup()).append("&clusterName=").append(node.getClusterName());
        if (node.getThreads() != 0) {
            path.append("&threads=").append(node.getThreads());
        }
        path.append("&identity=").append(node.getIdentity()).append("&createTime=").append(node.getCreateTime()).append("&isAvailable=").append(node.isAvailable()).append("&hostName=").append(node.getHostName());
        if (node.getHttpCmdPort() != null) {
            path.append("&httpCmdPort=").append(node.getHttpCmdPort());
        }
        return path.toString();
    }

    public static String getRealRegistryAddress(String registryAddress) {
        if (StringUtils.isEmpty(registryAddress)) {
            throw new IllegalArgumentException("registryAddress is null\uff01");
        }
        if (registryAddress.startsWith("zookeeper://")) {
            return registryAddress.replace("zookeeper://", "");
        }
        if (registryAddress.startsWith("redis://")) {
            return registryAddress.replace("redis://", "");
        }
        if (registryAddress.startsWith("multicast://")) {
            return registryAddress.replace("multicast://", "");
        }
        throw new IllegalArgumentException("Illegal registry protocol");
    }
}

