/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.remoting;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.exception.JobTrackerNotFoundException;
import com.github.ltsopensource.core.loadbalance.LoadBalance;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.spi.ServiceLoader;
import com.github.ltsopensource.ec.EventInfo;
import com.github.ltsopensource.remoting.AsyncCallback;
import com.github.ltsopensource.remoting.RemotingClient;
import com.github.ltsopensource.remoting.RemotingProcessor;
import com.github.ltsopensource.remoting.exception.RemotingException;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;

public class RemotingClientDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemotingClientDelegate.class);
    private RemotingClient remotingClient;
    private AppContext appContext;
    private volatile boolean serverEnable = false;
    private List<Node> jobTrackers;

    public RemotingClientDelegate(RemotingClient remotingClient, AppContext appContext) {
        this.remotingClient = remotingClient;
        this.appContext = appContext;
        this.jobTrackers = new CopyOnWriteArrayList<Node>();
    }

    private Node getJobTrackerNode() throws JobTrackerNotFoundException {
        try {
            if (this.jobTrackers.size() == 0) {
                throw new JobTrackerNotFoundException("no available jobTracker!");
            }
            LoadBalance loadBalance = ServiceLoader.load(LoadBalance.class, this.appContext.getConfig(), "jobtracker.select.loadbalance");
            return loadBalance.select(this.jobTrackers, this.appContext.getConfig().getIdentity());
        }
        catch (JobTrackerNotFoundException e) {
            this.serverEnable = false;
            EventInfo eventInfo = new EventInfo("NO_JOB_TRACKER_AVAILABLE");
            this.appContext.getEventCenter().publishAsync(eventInfo);
            throw e;
        }
    }

    public void start() {
        try {
            this.remotingClient.start();
        }
        catch (RemotingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean contains(Node jobTracker) {
        return this.jobTrackers.contains(jobTracker);
    }

    public void addJobTracker(Node jobTracker) {
        if (!this.contains(jobTracker)) {
            this.jobTrackers.add(jobTracker);
        }
    }

    public boolean removeJobTracker(Node jobTracker) {
        return this.jobTrackers.remove(jobTracker);
    }

    public RemotingCommand invokeSync(RemotingCommand request) throws JobTrackerNotFoundException {
        Node jobTracker = this.getJobTrackerNode();
        try {
            RemotingCommand response = this.remotingClient.invokeSync(jobTracker.getAddress(), request, this.appContext.getConfig().getInvokeTimeoutMillis());
            this.serverEnable = true;
            return response;
        }
        catch (Exception e) {
            this.jobTrackers.remove(jobTracker);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                LOGGER.error(e1.getMessage(), e1);
            }
            return this.invokeSync(request);
        }
    }

    public void invokeAsync(RemotingCommand request, AsyncCallback asyncCallback) throws JobTrackerNotFoundException {
        Node jobTracker = this.getJobTrackerNode();
        try {
            this.remotingClient.invokeAsync(jobTracker.getAddress(), request, this.appContext.getConfig().getInvokeTimeoutMillis(), asyncCallback);
            this.serverEnable = true;
        }
        catch (Throwable e) {
            this.jobTrackers.remove(jobTracker);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                LOGGER.error(e1.getMessage(), e1);
            }
            this.invokeAsync(request, asyncCallback);
        }
    }

    public void invokeOneway(RemotingCommand request) throws JobTrackerNotFoundException {
        Node jobTracker = this.getJobTrackerNode();
        try {
            this.remotingClient.invokeOneway(jobTracker.getAddress(), request, this.appContext.getConfig().getInvokeTimeoutMillis());
            this.serverEnable = true;
        }
        catch (Throwable e) {
            this.jobTrackers.remove(jobTracker);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                LOGGER.error(e1.getMessage(), e1);
            }
            this.invokeOneway(request);
        }
    }

    public void registerProcessor(int requestCode, RemotingProcessor processor, ExecutorService executor) {
        this.remotingClient.registerProcessor(requestCode, processor, executor);
    }

    public void registerDefaultProcessor(RemotingProcessor processor, ExecutorService executor) {
        this.remotingClient.registerDefaultProcessor(processor, executor);
    }

    public boolean isServerEnable() {
        return this.serverEnable;
    }

    public void setServerEnable(boolean serverEnable) {
        this.serverEnable = serverEnable;
    }

    public void shutdown() {
        this.remotingClient.shutdown();
    }

    public RemotingClient getRemotingClient() {
        return this.remotingClient;
    }
}

