/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.support;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class ConsistentHashSelector<S> {
    private TreeMap<Long, S> nodes = new TreeMap();
    private final int NODE_NUM = 100;

    public ConsistentHashSelector(List<S> shards) {
        for (int i = 0; i != shards.size(); ++i) {
            S shardInfo = shards.get(i);
            for (int n = 0; n < 100; ++n) {
                this.nodes.put(this.hash("SHARD-" + i + "-NODE-" + n), shardInfo);
            }
        }
    }

    public S selectForKey(String key) {
        SortedMap<Long, S> tail = this.nodes.tailMap(this.hash(key));
        if (tail.size() == 0) {
            return this.nodes.get(this.nodes.firstKey());
        }
        return (S)tail.get(tail.firstKey());
    }

    private Long hash(String key) {
        ByteBuffer buf = ByteBuffer.wrap(key.getBytes());
        int seed = 305441741;
        ByteOrder byteOrder = buf.order();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        long m = -4132994306676758123L;
        int r = 47;
        long h = (long)seed ^ (long)buf.remaining() * m;
        while (buf.remaining() >= 8) {
            long k = buf.getLong();
            k *= m;
            k ^= k >>> r;
            h ^= (k *= m);
            h *= m;
        }
        if (buf.remaining() > 0) {
            ByteBuffer finish = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
            finish.put(buf).rewind();
            h ^= finish.getLong();
            h *= m;
        }
        h ^= h >>> r;
        h *= m;
        h ^= h >>> r;
        buf.order(byteOrder);
        return h;
    }
}

