/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.json;

import com.github.ltsopensource.core.commons.utils.PrimitiveTypeUtils;
import com.github.ltsopensource.json.deserializer.ArrayDeserializer;
import com.github.ltsopensource.json.deserializer.CollectionDeserializer;
import com.github.ltsopensource.json.deserializer.Deserializer;
import com.github.ltsopensource.json.deserializer.EnumDeserializer;
import com.github.ltsopensource.json.deserializer.JavaBeanDeserializer;
import com.github.ltsopensource.json.deserializer.MapDeserializer;
import com.github.ltsopensource.json.deserializer.PrimitiveTypeDeserializer;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JSONParser {
    protected static final ConcurrentMap<Type, Deserializer> deserializerMap = new ConcurrentHashMap<Type, Deserializer>();

    public static <T> T parse(Object object, Type type) {
        Deserializer deserializer = JSONParser.getDeserializer(type);
        return deserializer.deserialize(object, type);
    }

    public static Deserializer getDeserializer(Type type) {
        Deserializer deserializer = (Deserializer)deserializerMap.get(type);
        if (deserializer != null) {
            return deserializer;
        }
        if (type instanceof Class) {
            return JSONParser.getDeserializer((Class)type, type);
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            if (rawType instanceof Class) {
                return JSONParser.getDeserializer((Class)rawType, type);
            }
            return JSONParser.getDeserializer(rawType);
        }
        if (type instanceof GenericArrayType) {
            return ArrayDeserializer.INSTANCE;
        }
        throw new IllegalArgumentException("can't get the Deserializer by " + type);
    }

    private static Deserializer getDeserializer(Class<?> clazz, Type type) {
        Deserializer deserializer = PrimitiveTypeUtils.isPrimitiveClass(clazz) ? new PrimitiveTypeDeserializer() : (clazz.isEnum() ? new EnumDeserializer(clazz) : (clazz.isArray() ? ArrayDeserializer.INSTANCE : (clazz == Set.class || clazz == HashSet.class || clazz == Collection.class || clazz == List.class || clazz == ArrayList.class ? CollectionDeserializer.INSTANCE : (Collection.class.isAssignableFrom(clazz) ? CollectionDeserializer.INSTANCE : (Map.class.isAssignableFrom(clazz) ? MapDeserializer.INSTANCE : new JavaBeanDeserializer(clazz))))));
        deserializerMap.put(type, deserializer);
        return deserializer;
    }
}

