/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jvmmonitor.mbean;

import com.github.ltsopensource.core.commons.utils.NetUtils;
import com.github.ltsopensource.jvmmonitor.mbean.JVMInfoMBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Date;
import java.util.Properties;

public class JVMInfo
implements JVMInfoMBean {
    private static final JVMInfo instance = new JVMInfo();
    private RuntimeMXBean runtimeMXBean;
    private ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
    private CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
    private Properties properties;
    private String inputArguments;
    private int availableProcessors = 0;
    private String pid;

    public static JVMInfo getInstance() {
        return instance;
    }

    private JVMInfo() {
        this.runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        this.properties = System.getProperties();
    }

    private String getSystemProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public Date getStartTime() {
        return new Date(this.runtimeMXBean.getStartTime());
    }

    @Override
    public String getJVM() {
        return this.runtimeMXBean.getVmName() + " (" + this.runtimeMXBean.getVmVersion() + ", " + this.getSystemProperty("java.vm.info") + ")";
    }

    @Override
    public String getJavaVersion() {
        return this.getSystemProperty("java.version");
    }

    @Override
    public String getPID() {
        if (null == this.pid) {
            this.pid = this.runtimeMXBean.getName().split("@")[0];
        }
        return this.pid;
    }

    @Override
    public String getInputArguments() {
        if (null == this.inputArguments) {
            this.inputArguments = this.runtimeMXBean.getInputArguments().toString();
        }
        return this.inputArguments;
    }

    @Override
    public String getJavaHome() {
        return this.getSystemProperty("java.home");
    }

    @Override
    public String getArch() {
        return this.getSystemProperty("os.arch");
    }

    @Override
    public String getOSName() {
        return this.getSystemProperty("os.name");
    }

    @Override
    public String getOSVersion() {
        return this.getSystemProperty("os.version");
    }

    @Override
    public String getJavaSpecificationVersion() {
        return this.getSystemProperty("java.specification.version");
    }

    @Override
    public String getJavaLibraryPath() {
        return this.getSystemProperty("java.library.path");
    }

    @Override
    public String getFileEncode() {
        return this.getSystemProperty("file.encoding");
    }

    @Override
    public int getAvailableProcessors() {
        if (this.availableProcessors == 0) {
            this.availableProcessors = Runtime.getRuntime().availableProcessors();
        }
        return this.availableProcessors;
    }

    @Override
    public int getLoadedClassCount() {
        return this.classLoadingMXBean.getLoadedClassCount();
    }

    @Override
    public long getTotalLoadedClassCount() {
        return this.classLoadingMXBean.getTotalLoadedClassCount();
    }

    @Override
    public long getUnloadedClassCount() {
        return this.classLoadingMXBean.getUnloadedClassCount();
    }

    @Override
    public long getTotalCompilationTime() {
        return this.compilationMXBean.getTotalCompilationTime();
    }

    @Override
    public String getHostName() {
        return NetUtils.getLocalHostName();
    }

    @Override
    public String getLocalIp() {
        return NetUtils.getLocalHost();
    }
}

