/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.kv.data;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.kv.DB;
import com.github.ltsopensource.kv.StoreConfig;
import com.github.ltsopensource.kv.data.DataBlock;
import com.github.ltsopensource.kv.data.DataBlockEngine;
import com.github.ltsopensource.kv.index.Index;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class DataCompactor<K, V> {
    private static final Logger LOGGER = DB.LOGGER;
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> future;
    private StoreConfig storeConfig;
    private Index<K, V> index;
    private DataBlockEngine<K, V> dataBlockEngine;
    private AtomicBoolean running = new AtomicBoolean(false);

    public void init() {
        this.future = this.executorService.scheduleWithFixedDelay(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!DataCompactor.this.running.compareAndSet(false, true)) {
                    return;
                }
                try {
                    DataCompactor.this.compact();
                }
                catch (Throwable t) {
                    LOGGER.error("DataCompactor compactor error:" + t.getMessage(), t);
                }
                finally {
                    DataCompactor.this.running.set(false);
                }
            }
        }, this.storeConfig.getDataBlockCompactCheckInterval(), this.storeConfig.getDataBlockCompactCheckInterval(), TimeUnit.MILLISECONDS);
    }

    private void compact() {
        List<DataBlock> readonlyBlocks = this.dataBlockEngine.getReadonlyBlocks();
    }
}

