/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.kv.index;

import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.kv.Entry;
import com.github.ltsopensource.kv.StoreConfig;
import com.github.ltsopensource.kv.cache.DataCache;
import com.github.ltsopensource.kv.data.DataBlockEngine;
import com.github.ltsopensource.kv.index.Index;
import com.github.ltsopensource.kv.index.IndexItem;
import com.github.ltsopensource.kv.index.IndexSnapshot;
import com.github.ltsopensource.kv.iterator.DBIterator;
import com.github.ltsopensource.kv.iterator.MemIteratorImpl;
import com.github.ltsopensource.kv.txlog.StoreTxLogPosition;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class MemIndex<K, V>
implements Index<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemIndex.class);
    private StoreTxLogPosition lastTxLog;
    private ConcurrentMap<K, IndexItem<K>> indexMap;
    private StoreConfig storeConfig;
    private DataBlockEngine<K, V> dataBlockEngine;
    private DataCache<K, V> dataCache;
    private AtomicLong lastSnapshotChangeNum = new AtomicLong(0L);
    private AtomicLong currentChangeNum = new AtomicLong(0L);
    private IndexSnapshot<K, V> indexSnapshot;

    public MemIndex(final StoreConfig storeConfig, DataBlockEngine<K, V> dataBlockEngine, DataCache<K, V> dataCache) {
        this.indexMap = new ConcurrentSkipListMap<K, IndexItem<K>>();
        this.storeConfig = storeConfig;
        this.dataBlockEngine = dataBlockEngine;
        this.dataCache = dataCache;
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("ltsdb-index-snapshot-check-service", true));
        executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    if (MemIndex.this.currentChangeNum.get() - MemIndex.this.lastSnapshotChangeNum.get() > (long)storeConfig.getIndexSnapshotThreshold()) {
                        MemIndex.this.indexSnapshot.snapshot();
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("SNAPSHOT Error", t);
                }
            }
        }, 3L, 2L, TimeUnit.SECONDS);
    }

    @Override
    public IndexItem<K> getIndexItem(K key) {
        return (IndexItem)this.indexMap.get(key);
    }

    @Override
    public IndexItem<K> removeIndexItem(StoreTxLogPosition txLogResult, K key) {
        IndexItem value = (IndexItem)this.indexMap.remove(key);
        this.lastTxLog = txLogResult;
        this.currentChangeNum.incrementAndGet();
        return value;
    }

    @Override
    public void putIndexItem(StoreTxLogPosition txLogResult, K key, IndexItem<K> indexItem) {
        this.indexMap.put(key, indexItem);
        this.lastTxLog = txLogResult;
        this.currentChangeNum.incrementAndGet();
    }

    @Override
    public int size() {
        return this.indexMap.size();
    }

    @Override
    public boolean containsKey(K key) {
        return this.indexMap.containsKey(key);
    }

    @Override
    public DBIterator<Entry<K, V>> iterator() {
        return new MemIteratorImpl<K, V>(this, this.dataBlockEngine, this.dataCache);
    }

    @Override
    public StoreTxLogPosition lastTxLog() {
        return this.lastTxLog;
    }

    void setLastTxLog(StoreTxLogPosition lastTxLog) {
        this.lastTxLog = lastTxLog;
    }

    public ConcurrentMap<K, IndexItem<K>> getIndexMap() {
        return this.indexMap;
    }

    void setIndexMap(ConcurrentMap<K, IndexItem<K>> indexMap) {
        this.indexMap = indexMap;
    }

    public void setIndexSnapshot(IndexSnapshot<K, V> indexSnapshot) {
        this.indexSnapshot = indexSnapshot;
    }
}

