/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.nio.channel;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.nio.channel.NioChannel;
import com.github.ltsopensource.nio.codec.Decoder;
import com.github.ltsopensource.nio.codec.Encoder;
import com.github.ltsopensource.nio.config.NioConfig;
import com.github.ltsopensource.nio.handler.Futures;
import com.github.ltsopensource.nio.handler.NioHandler;
import com.github.ltsopensource.nio.idle.IdleInfo;
import com.github.ltsopensource.nio.idle.IdleState;
import com.github.ltsopensource.nio.loop.NioSelectorLoop;
import com.github.ltsopensource.nio.processor.NioProcessor;
import io.netty.util.internal.ThreadLocalRandom;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicInteger;

public class NioChannelImpl
implements NioChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(NioChannelImpl.class);
    private final long id;
    private static final AtomicInteger CONN_ID = new AtomicInteger(0);
    private NioProcessor processor;
    private NioSelectorLoop selectorLoop;
    protected Futures.CloseFuture closeFuture = Futures.newCloseFuture();
    private IdleInfo idleInfo;
    private NioConfig config;
    private Decoder decoder;
    private Encoder encoder;
    private final long hashCode = ThreadLocalRandom.current().nextLong();
    protected SocketChannel channel;
    private NioHandler eventHandler;

    public NioChannelImpl(NioSelectorLoop selectorLoop, NioProcessor processor, SocketChannel channel, NioHandler eventHandler, NioConfig config) {
        this.channel = channel;
        this.selectorLoop = selectorLoop;
        this.processor = processor;
        this.eventHandler = eventHandler;
        this.id = CONN_ID.incrementAndGet();
        this.idleInfo = new IdleInfo();
        this.config = config;
        this.closeFuture.setChannel(this);
    }

    public SelectableChannel javaChannel() {
        return this.channel;
    }

    @Override
    public SocketChannel socketChannel() {
        return this.channel;
    }

    public NioHandler eventHandler() {
        return this.eventHandler;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Futures.WriteFuture writeAndFlush(Object msg) {
        return this.processor.writeAndFlush(this, msg);
    }

    @Override
    public void setLastReadTime(long lastReadTime) {
        this.idleInfo.setLastReadTime(lastReadTime);
    }

    @Override
    public void setLastWriteTime(long lastWriteTime) {
        this.idleInfo.setLastWriteTime(lastWriteTime);
    }

    public Selector selector() {
        return this.selectorLoop.selector();
    }

    @Override
    public Futures.CloseFuture close() {
        try {
            this.javaChannel().close();
            this.closeFuture.setSuccess(true);
        }
        catch (IOException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("caught connection exception", e);
            }
            this.closeFuture.setSuccess(false);
            this.closeFuture.setCause(e);
            this.eventHandler().exceptionCaught(this, e);
        }
        this.closeFuture.notifyListeners();
        return this.closeFuture;
    }

    @Override
    public Futures.CloseFuture getCloseFuture() {
        return this.closeFuture;
    }

    @Override
    public boolean isOpen() {
        return this.javaChannel().isOpen();
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.socketChannel().socket().getRemoteSocketAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return this.socketChannel().socket().getLocalSocketAddress();
    }

    @Override
    public boolean isConnected() {
        return !this.closeFuture.isDone();
    }

    public IdleInfo getIdleInfo() {
        return this.idleInfo;
    }

    public NioConfig getConfig() {
        return this.config;
    }

    public void fireChannelIdle(IdleState state, long currentTime) {
        switch (state) {
            case BOTH_IDLE: {
                this.idleInfo.setLastBothIdleTime(currentTime);
                break;
            }
            case WRITER_IDLE: {
                this.idleInfo.setLastWriteIdleTime(currentTime);
                break;
            }
            case READER_IDLE: {
                this.idleInfo.setLastReadIdleTime(currentTime);
            }
        }
        this.eventHandler().channelIdle(this, state);
    }

    @Override
    public Decoder getDecoder() {
        return this.decoder;
    }

    public void setDecoder(Decoder decoder) {
        this.decoder = decoder;
    }

    @Override
    public Encoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder encoder) {
        this.encoder = encoder;
    }

    public final int hashCode() {
        return (int)this.hashCode;
    }

    public final boolean equals(Object o) {
        return this == o;
    }
}

