/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.nio.loop;

import com.github.ltsopensource.core.constant.Constants;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.nio.NioException;
import com.github.ltsopensource.nio.channel.NioChannel;
import com.github.ltsopensource.nio.processor.NioProcessor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class NioSelectorLoop {
    private static final Logger LOGGER;
    private static final int SELECTOR_AUTO_REBUILD_THRESHOLD = 512;
    private static final int MIN_PREMATURE_SELECTOR_RETURNS = 3;
    private Selector selector = this.openSelector();
    private SelectorWorker selectorWorker;
    private volatile boolean running = false;
    private static boolean isLinuxPlatform;

    public NioSelectorLoop(String name, NioProcessor processor) {
        this.selectorWorker = new SelectorWorker(name, processor);
    }

    private static boolean isLinuxPlatform() {
        return isLinuxPlatform;
    }

    private Selector openSelector() {
        AbstractSelector result = null;
        if (NioSelectorLoop.isLinuxPlatform()) {
            try {
                SelectorProvider selectorProvider;
                Method method;
                Class<?> providerClazz = Class.forName("sun.nio.ch.EPollSelectorProvider");
                if (providerClazz != null && (method = providerClazz.getMethod("provider", new Class[0])) != null && (selectorProvider = (SelectorProvider)method.invoke(null, new Object[0])) != null) {
                    result = selectorProvider.openSelector();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (result == null) {
            try {
                result = SelectorProvider.provider().openSelector();
            }
            catch (IOException e) {
                throw new NioException("open selector error:" + e.getMessage(), e);
            }
        }
        return result;
    }

    public Selector selector() {
        return this.selector;
    }

    public void start() {
        this.running = true;
        this.selectorWorker.start();
    }

    public void shutdown() {
        this.running = false;
    }

    private void select() throws IOException {
        block6: {
            Selector selector = this.selector;
            try {
                int selectCnt = 0;
                long currentNanoTime = System.nanoTime();
                long selectDeadLineNanos = currentNanoTime + TimeUnit.SECONDS.toNanos(1L);
                while (true) {
                    long timeoutMillis;
                    if ((timeoutMillis = (selectDeadLineNanos - currentNanoTime + 500000L) / 1000000L) <= 0L) {
                        if (selectCnt != 0) break;
                        selector.selectNow();
                        selectCnt = 1;
                        break;
                    }
                    int selectedKeys = selector.select(timeoutMillis);
                    ++selectCnt;
                    if (selectedKeys != 0) break;
                    if (selectCnt >= 512) {
                        LOGGER.warn("Selector.select() returned prematurely {} times in a row; rebuilding selector.", selectCnt);
                        this.rebuildSelector();
                        selector = this.selector;
                        selector.selectNow();
                        selectCnt = 1;
                        break;
                    }
                    currentNanoTime = System.nanoTime();
                }
                if (selectCnt > 3 && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Selector.select() returned prematurely {} times in a row.", selectCnt - 1);
                }
            }
            catch (CancelledKeyException e) {
                if (!LOGGER.isDebugEnabled()) break block6;
                LOGGER.debug(CancelledKeyException.class.getSimpleName() + " raised by a Selector - JDK bug?", e);
            }
        }
    }

    private void rebuildSelector() {
        int nChannels;
        block11: {
            Selector newSelector;
            Selector oldSelector = this.selector;
            if (oldSelector == null) {
                return;
            }
            try {
                newSelector = this.openSelector();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to create a new Selector.", e);
                return;
            }
            nChannels = 0;
            while (true) {
                try {
                    for (SelectionKey key : oldSelector.keys()) {
                        Object a = key.attachment();
                        try {
                            if (key.channel().keyFor(newSelector) != null) continue;
                            int interestOps = key.interestOps();
                            key.cancel();
                            key.channel().register(newSelector, interestOps, a);
                            ++nChannels;
                        }
                        catch (Exception e) {
                            LOGGER.warn("Failed to re-register a Channel to the new Selector.", e);
                        }
                    }
                }
                catch (ConcurrentModificationException e) {
                    continue;
                }
                break;
            }
            this.selector = newSelector;
            try {
                oldSelector.close();
            }
            catch (Throwable t) {
                if (!LOGGER.isWarnEnabled()) break block11;
                LOGGER.warn("Failed to close the old Selector.", t);
            }
        }
        LOGGER.info("Migrated " + nChannels + " channel(s) to the new Selector.");
    }

    static {
        block4: {
            LOGGER = LoggerFactory.getLogger(NioSelectorLoop.class);
            isLinuxPlatform = false;
            if (Constants.OS_NAME != null && Constants.OS_NAME.toLowerCase().contains("linux")) {
                isLinuxPlatform = true;
            }
            String key = "sun.nio.ch.bugLevel";
            try {
                String bugLevel = System.getProperty(key);
                if (bugLevel == null) {
                    System.setProperty(key, "");
                }
            }
            catch (SecurityException e) {
                if (!LOGGER.isDebugEnabled()) break block4;
                LOGGER.debug("Unable to get/set System Property: {}", key, e);
            }
        }
    }

    private class SelectorWorker
    extends Thread {
        private NioProcessor processor;

        public SelectorWorker(String name, NioProcessor processor) {
            super(name);
            this.setDaemon(true);
            this.processor = processor;
        }

        @Override
        public void run() {
            while (NioSelectorLoop.this.running) {
                try {
                    NioSelectorLoop.this.select();
                    Set<SelectionKey> selectionKeys = NioSelectorLoop.this.selector.selectedKeys();
                    if (selectionKeys.isEmpty()) continue;
                    Iterator<SelectionKey> iterator = selectionKeys.iterator();
                    while (iterator.hasNext()) {
                        SelectionKey key = iterator.next();
                        iterator.remove();
                        if (!key.isValid()) continue;
                        if (key.isAcceptable()) {
                            this.doAccept(key);
                        }
                        if (key.isConnectable()) {
                            this.doConnect(key);
                        }
                        if (key.isValid() && key.isReadable()) {
                            this.doRead(key);
                        }
                        if (!key.isValid() || !key.isWritable()) continue;
                        this.doWrite(key);
                    }
                }
                catch (Throwable t) {
                    LOGGER.warn("Unexpected exception in the selector loop.", t);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        private void doAccept(SelectionKey key) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("doAccept:" + key.toString());
            }
            this.processor.accept(key);
        }

        private void doConnect(SelectionKey key) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("doConnect:" + key.toString());
            }
            this.processor.connect(key);
        }

        private void doRead(SelectionKey key) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("doRead:" + key.toString());
            }
            NioChannel channel = (NioChannel)key.attachment();
            this.processor.read(channel);
        }

        private void doWrite(SelectionKey key) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("doWrite:" + key.toString());
            }
            NioChannel channel = (NioChannel)key.attachment();
            this.processor.flush(channel);
        }
    }
}

