/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.queue;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.commons.concurrent.ConcurrentHashSet;
import com.github.ltsopensource.core.commons.utils.Callable;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.DotLogUtils;
import com.github.ltsopensource.core.commons.utils.PeriodUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.support.NodeShutdownHook;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.queue.JobPriorityBlockingDeque;
import com.github.ltsopensource.queue.PreLoader;
import com.github.ltsopensource.queue.domain.JobPo;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractPreLoader
implements PreLoader {
    private int loadSize;
    private double factor;
    private ConcurrentHashMap<String, JobPriorityBlockingDeque> JOB_MAP = new ConcurrentHashMap();
    private ConcurrentHashSet<String> LOAD_SIGNAL = new ConcurrentHashSet();
    private ScheduledExecutorService LOAD_EXECUTOR_SERVICE = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("LTS-PreLoader", true));
    private ScheduledFuture<?> scheduledFuture;
    private AtomicBoolean start = new AtomicBoolean(false);
    private String FORCE_PREFIX = "force_";
    private ConcurrentHashMap<String, AtomicBoolean> LOADING = new ConcurrentHashMap();

    public AbstractPreLoader(AppContext appContext) {
        if (this.start.compareAndSet(false, true)) {
            this.loadSize = appContext.getConfig().getParameter("job.preloader.size", 300);
            this.factor = appContext.getConfig().getParameter("job.preloader.factor", 0.2);
            long interval = appContext.getConfig().getParameter("job.preloader.signal.check.interval", 100);
            this.scheduledFuture = this.LOAD_EXECUTOR_SERVICE.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    AbstractPreLoader.this.doLoad();
                }
            }, interval, interval, TimeUnit.MILLISECONDS);
            NodeShutdownHook.registerHook(appContext, this.getClass().getName(), new Callable(){

                @Override
                public void call() throws Exception {
                    AbstractPreLoader.this.scheduledFuture.cancel(true);
                    AbstractPreLoader.this.LOAD_EXECUTOR_SERVICE.shutdown();
                    AbstractPreLoader.this.start.set(false);
                }
            });
        }
    }

    private void doLoad() {
        for (final String loadTaskTrackerNodeGroup : this.LOAD_SIGNAL) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AtomicBoolean loading = (AtomicBoolean)AbstractPreLoader.this.LOADING.get(loadTaskTrackerNodeGroup);
                    if (loading == null) {
                        loading = new AtomicBoolean(false);
                        AtomicBoolean _loading = AbstractPreLoader.this.LOADING.putIfAbsent(loadTaskTrackerNodeGroup, loading);
                        if (_loading != null) {
                            loading = _loading;
                        }
                    }
                    if (loading.compareAndSet(false, true)) {
                        try {
                            AbstractPreLoader.this.handleSignal(loadTaskTrackerNodeGroup);
                        }
                        finally {
                            loading.compareAndSet(true, false);
                        }
                    }
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleSignal(String loadTaskTrackerNodeGroup) {
        JobPriorityBlockingDeque queue;
        boolean force = false;
        if (loadTaskTrackerNodeGroup.startsWith(this.FORCE_PREFIX)) {
            loadTaskTrackerNodeGroup = loadTaskTrackerNodeGroup.replaceFirst(this.FORCE_PREFIX, "");
            force = true;
        }
        if ((queue = this.JOB_MAP.get(loadTaskTrackerNodeGroup)) == null) {
            return;
        }
        int size = queue.size();
        if (force || this.isInFactor(size)) {
            int needLoadSize = this.loadSize + size;
            if (force) {
                needLoadSize = this.loadSize;
            }
            PeriodUtils.start();
            List<JobPo> loads = null;
            try {
                loads = this.load(loadTaskTrackerNodeGroup, needLoadSize);
            }
            catch (Throwable throwable) {
                PeriodUtils.end("AbstractPreLoader.load loadTaskTrackerNodeGroup:{},loadSide={}", loadTaskTrackerNodeGroup, needLoadSize);
                throw throwable;
            }
            PeriodUtils.end("AbstractPreLoader.load loadTaskTrackerNodeGroup:{},loadSide={}", loadTaskTrackerNodeGroup, needLoadSize);
            if (CollectionUtils.isNotEmpty(loads)) {
                PeriodUtils.start();
                try {
                    for (JobPo load : loads) {
                        if (queue.offer(load)) continue;
                        if (force) {
                            queue.pollLast();
                            queue.offer(load);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    PeriodUtils.end("AbstractPreLoader.offer loadTaskTrackerNodeGroup:{},loadSide={}", loadTaskTrackerNodeGroup, needLoadSize);
                    throw throwable;
                }
                PeriodUtils.end("AbstractPreLoader.offer loadTaskTrackerNodeGroup:{},loadSide={}", loadTaskTrackerNodeGroup, needLoadSize);
            }
        }
        this.LOAD_SIGNAL.remove(loadTaskTrackerNodeGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JobPo take(String taskTrackerNodeGroup, String taskTrackerIdentity) {
        while (true) {
            JobPo jobPo;
            block4: {
                JobPo jobPo2;
                if ((jobPo = this.get(taskTrackerNodeGroup)) == null) {
                    DotLogUtils.dot("Empty JobQueue, taskTrackerNodeGroup:{}, taskTrackerIdentity:{}", taskTrackerNodeGroup, taskTrackerIdentity);
                    return null;
                }
                PeriodUtils.start();
                try {
                    if (!this.lockJob(taskTrackerNodeGroup, jobPo.getJobId(), taskTrackerIdentity, jobPo.getTriggerTime(), jobPo.getGmtModified())) break block4;
                    jobPo.setTaskTrackerIdentity(taskTrackerIdentity);
                    jobPo.setIsRunning(true);
                    jobPo.setGmtModified(SystemClock.now());
                    jobPo2 = jobPo;
                }
                catch (Throwable throwable) {
                    PeriodUtils.end("AbstractPreLoader.lockJob taskId:{}", jobPo.getTaskId());
                    throw throwable;
                }
                PeriodUtils.end("AbstractPreLoader.lockJob taskId:{}", jobPo.getTaskId());
                return jobPo2;
            }
            PeriodUtils.end("AbstractPreLoader.lockJob taskId:{}", jobPo.getTaskId());
        }
    }

    @Override
    public void load(String taskTrackerNodeGroup) {
        if (StringUtils.isEmpty(taskTrackerNodeGroup)) {
            for (String key : this.JOB_MAP.keySet()) {
                this.LOAD_SIGNAL.add(this.FORCE_PREFIX + key);
            }
            return;
        }
        this.LOAD_SIGNAL.add(this.FORCE_PREFIX + taskTrackerNodeGroup);
    }

    @Override
    public void loadOne2First(String taskTrackerNodeGroup, String jobId) {
        JobPo jobPo = this.getJob(taskTrackerNodeGroup, jobId);
        if (jobPo == null) {
            return;
        }
        JobPriorityBlockingDeque queue = this.getQueue(taskTrackerNodeGroup);
        jobPo.setInternalExtParam("__LTS_Tmp_Old_Priority", String.valueOf(jobPo.getPriority()));
        jobPo.setPriority(Integer.MIN_VALUE);
        if (!queue.offer(jobPo)) {
            queue.pollLast();
            queue.offer(jobPo);
        }
    }

    protected abstract JobPo getJob(String var1, String var2);

    protected abstract boolean lockJob(String var1, String var2, String var3, Long var4, Long var5);

    protected abstract List<JobPo> load(String var1, int var2);

    private JobPo get(String taskTrackerNodeGroup) {
        JobPo jobPo;
        JobPriorityBlockingDeque queue = this.getQueue(taskTrackerNodeGroup);
        int size = queue.size();
        DotLogUtils.dot("AbstractPreLoader.queue size:{},taskTrackerNodeGroup:{}", size, taskTrackerNodeGroup);
        if (this.isInFactor(size) && !this.LOAD_SIGNAL.contains(taskTrackerNodeGroup)) {
            this.LOAD_SIGNAL.add(taskTrackerNodeGroup);
            this.doLoad();
        }
        if ((jobPo = queue.poll()) != null && jobPo.getPriority() == Integer.MIN_VALUE && CollectionUtils.isNotEmpty(jobPo.getInternalExtParams()) && jobPo.getInternalExtParams().containsKey("__LTS_Tmp_Old_Priority")) {
            try {
                int priority = Integer.parseInt(jobPo.getInternalExtParam("__LTS_Tmp_Old_Priority"));
                jobPo.getInternalExtParams().remove("__LTS_Tmp_Old_Priority");
                jobPo.setPriority(priority);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        return jobPo;
    }

    private boolean isInFactor(int size) {
        return (double)size / ((double)this.loadSize * 1.0) < this.factor;
    }

    private JobPriorityBlockingDeque getQueue(String taskTrackerNodeGroup) {
        JobPriorityBlockingDeque oldQueue;
        JobPriorityBlockingDeque queue = this.JOB_MAP.get(taskTrackerNodeGroup);
        if (queue == null && (oldQueue = this.JOB_MAP.putIfAbsent(taskTrackerNodeGroup, queue = new JobPriorityBlockingDeque(this.loadSize))) != null) {
            queue = oldQueue;
        }
        return queue;
    }
}

