/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.queue;

import com.github.ltsopensource.queue.domain.JobPo;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class JobPriorityBlockingDeque {
    private final int capacity;
    private final LinkedList<JobPo> list;
    private final ReentrantLock lock = new ReentrantLock();
    private Map<String, Long> jobs = new ConcurrentHashMap<String, Long>();
    private Comparator<JobPo> comparator;

    public JobPriorityBlockingDeque(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.list = new LinkedList();
        this.comparator = new Comparator<JobPo>(){

            @Override
            public int compare(JobPo left, JobPo right) {
                if (left.getJobId().equals(right.getJobId())) {
                    return 0;
                }
                int compare = left.getPriority().compareTo(right.getPriority());
                if (compare != 0) {
                    return compare;
                }
                compare = left.getTriggerTime().compareTo(right.getTriggerTime());
                if (compare != 0) {
                    return compare;
                }
                compare = left.getGmtCreated().compareTo(right.getGmtCreated());
                if (compare != 0) {
                    return compare;
                }
                return -1;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobPo pollFirst() {
        this.lock.lock();
        try {
            JobPo f = this.list.pollFirst();
            if (f == null) {
                JobPo jobPo = null;
                return jobPo;
            }
            this.jobs.remove(f.getJobId());
            JobPo jobPo = f;
            return jobPo;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobPo pollLast() {
        this.lock.lock();
        try {
            JobPo l = this.list.pollLast();
            if (l == null) {
                JobPo jobPo = null;
                return jobPo;
            }
            this.jobs.remove(l.getJobId());
            JobPo jobPo = l;
            return jobPo;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(JobPo e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.list.size() >= this.capacity) {
            return false;
        }
        this.lock.lock();
        try {
            int insertionPoint;
            Long gmtModified;
            if (this.jobs.containsKey(e.getJobId()) && (gmtModified = this.jobs.get(e.getJobId())) != null && !gmtModified.equals(e.getGmtModified())) {
                this.removeOld(e);
            }
            if ((insertionPoint = Collections.binarySearch(this.list, e, this.comparator)) < 0) {
                insertionPoint = -insertionPoint - 1;
            }
            this.list.add(insertionPoint, e);
            this.jobs.put(e.getJobId(), e.getGmtModified());
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removeOld(JobPo e) {
        Iterator<JobPo> i = this.iterator();
        int index = 0;
        while (i.hasNext()) {
            JobPo o = i.next();
            if (o.getJobId().equals(e.getJobId())) {
                this.list.remove(index);
                this.jobs.remove(e.getJobId());
                return;
            }
            ++index;
        }
    }

    public JobPo poll() {
        return this.pollFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.lock();
        try {
            int n = this.list.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        this.lock.lock();
        try {
            Iterator<JobPo> i = this.iterator();
            if (!i.hasNext()) {
                String string = "[]";
                return string;
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            while (true) {
                JobPo e = i.next();
                sb.append(e);
                if (!i.hasNext()) {
                    String string = sb.append(']').toString();
                    return string;
                }
                sb.append(", ");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Iterator<JobPo> iterator() {
        return this.list.iterator();
    }
}

